/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.DivHelpContentDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.DivHelpContent;
import eu.dnetlib.uoaadmintoolslibrary.entities.DivId;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivIdResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.DivIdService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DivHelpContentService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private DivHelpContentDAO divHelpContentDAO;
    @Autowired
    private DivIdService divIdService;

    public List<DivHelpContentResponse> getDivHelpContents(Portal portal) {
        return this.getDivHelpContents(portal, null, null, null);
    }

    public List<DivHelpContentResponse> getDivHelpContents(Portal portal, String pageRoute, String divIdId, String active) {
        ArrayList<DivHelpContentResponse> divHelpContentResponses = new ArrayList<DivHelpContentResponse>();
        List<DivHelpContent> divHelpContents = null;
        divHelpContents = portal != null && divIdId != null && active != null ? this.divHelpContentDAO.findByPortalAndDivIdAndIsActive(portal.getId(), divIdId, Boolean.parseBoolean(active)) : (portal != null && divIdId != null ? this.divHelpContentDAO.findByPortalAndDivId(portal.getId(), divIdId) : (portal != null && active != null ? this.divHelpContentDAO.findByPortalAndIsActive(portal.getId(), Boolean.parseBoolean(active)) : (divIdId != null && active != null ? this.divHelpContentDAO.findByDivIdAndIsActive(divIdId, Boolean.parseBoolean(active)) : (portal != null ? this.divHelpContentDAO.findByPortal(portal.getId()) : (divIdId != null ? this.divHelpContentDAO.findByDivId(divIdId) : (active != null ? this.divHelpContentDAO.findByIsActive(Boolean.parseBoolean(active)) : this.divHelpContentDAO.findAll()))))));
        block0: for (DivHelpContent divHelpContent : divHelpContents) {
            DivIdResponse divIdResponse = null;
            DivId divId = divIdId == null ? this.divIdService.getDivId(divHelpContent.getDivId()) : this.divIdService.getDivId(divIdId);
            divIdResponse = this.divIdService.divIdResponseFromDivId(divId);
            for (Page p : divIdResponse.getPages()) {
                if (pageRoute != null && !p.getRoute().equals(pageRoute)) continue;
                DivHelpContentResponse divHelpContentResponse = new DivHelpContentResponse(divHelpContent);
                divHelpContentResponse.setDivId(divIdResponse);
                divHelpContentResponse.setPortal(portal);
                divHelpContentResponses.add(divHelpContentResponse);
                continue block0;
            }
        }
        return divHelpContentResponses;
    }

    public List<DivHelpContent> getDivHelpContentsBasic(Portal portal, String pageId) {
        List<DivHelpContent> divHelpContents;
        List<DivHelpContent> list = divHelpContents = portal != null ? this.divHelpContentDAO.findByPortal(portal.getId()) : this.divHelpContentDAO.findAll();
        if (pageId != null) {
            Iterator<DivHelpContent> divHelpContentsIterator = divHelpContents.iterator();
            while (divHelpContentsIterator.hasNext()) {
                DivHelpContent divHelpContent = divHelpContentsIterator.next();
                String divIdId = divHelpContent.getDivId();
                DivId divId = this.divIdService.getDivId(divIdId);
                boolean remove = true;
                for (String pageIdInDivId : divId.getPages()) {
                    if (!pageId.equals(pageIdInDivId)) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                divHelpContentsIterator.remove();
            }
        }
        return divHelpContents;
    }

    public DivHelpContent getDivHelpContent(String id) {
        return this.getDivHelpContent(id, null);
    }

    public DivHelpContent getDivHelpContent(String id, Portal portal) {
        if (portal != null) {
            return this.divHelpContentDAO.findByIdAndPortal(id, portal.getId()).orElseThrow(() -> new NotFoundException("Div help content in portal: " + String.valueOf(portal) + " not found: " + id));
        }
        return (DivHelpContent)this.divHelpContentDAO.findById(id).orElseThrow(() -> new NotFoundException("Div help content not found: " + id));
    }

    public DivHelpContent insertOrUpdateDivHelpContent(DivHelpContent divHelpContent) {
        return (DivHelpContent)this.divHelpContentDAO.save(divHelpContent);
    }

    public void deleteDivHelpContent(String id) {
        this.divHelpContentDAO.deleteById(id);
    }

    public Boolean deleteDivHelpContents(Portal portal, List<String> divHelpContents) {
        for (String id : divHelpContents) {
            DivHelpContent divHelpContent = this.getDivHelpContent(id);
            if (!divHelpContent.getPortal().equals(portal.getId())) {
                throw new MismatchingContentException("[" + portal.getType() + " - " + portal.getPid() + "] Conflicting div help content: portal id: " + divHelpContent.getPortal());
            }
            this.divHelpContentDAO.deleteById(id);
        }
        return true;
    }

    public List<String> toggleDivHelpContent(Portal portal, List<String> divHelpContents, String status) {
        for (String id : divHelpContents) {
            this.log.debug("Id of divHelpContent: " + id);
            DivHelpContent divHelpContent = this.getDivHelpContent(id);
            if (!divHelpContent.getPortal().equals(portal.getId())) {
                throw new MismatchingContentException("[" + portal.getType() + " - " + portal.getPid() + "] Conflicting div help content: portal id: " + divHelpContent.getPortal());
            }
            divHelpContent.setIsActive(Boolean.parseBoolean(status));
            this.divHelpContentDAO.save(divHelpContent);
        }
        return divHelpContents;
    }

    public void addDivHelpContentsInPortal(Portal portal) {
        String link_context_form_content = "<div> <div><span class=\"uk-text-bold\"><span uk-icon=\"icon: info\">&nbsp;</span> Information:</span> Select a research portal and/or a category and search for a portal concept, or browse to the portal tree through the categories</div> </div>";
        String link_project_form_content = "<div> <div><span class=\"uk-text-bold\"><span uk-icon=\"icon: info\">&nbsp;</span> Information:</span> Search for projects using project name or grant id. Limit results filtering by funder.</div> </div>";
        String link_result_form_content = "<div> <div><span class=\"uk-text-bold\"><span uk-icon=\"icon: info\">&nbsp;</span> Information:</span></div> Search for research results in OpenAIRE information space, Datacite, CrossRef or ORCID. <div class=\"uk-text-small\">Use keywords, DOI (more than one - space separated), author&#39;s ORCID</div> </div>";
        String link_result_bulk_content = "<div> <div><span class=\"uk-text-bold\"><span uk-icon=\"icon: info\">&nbsp;</span> Information:</span> Upload a csv file containing a list of DOIs. For each DOI found in the file, metadata will be fetched from CrossRef or Datacite and will be added to your selected research results.</div> <div class=\"uk-margin-top uk-text-small\"><span class=\"uk-text-bold\">CSV format:</span> <ul class=\"uk-list\"> <li>The format of CSV file should be &quot;DOI&quot;,&quot;ACCESS_MODE&quot;,&quot;DATE&quot;.</li> <li>The value &quot;DOI&quot; is required</li> <li>Access mode column should have values: &quot;OPEN&quot;,&quot;CLOSED&quot; or &quot;EMBARGO&quot;.</li> <li>Date column valid format is YYYY-MM-DD and is required when access mode has value EMBARGO.</li> <li>In case access mode is not available default value is &quot;OPEN&quot;.</li> </ul> </div> </div>";
        String link_metadata_content = "<div> <div><span class=\"uk-text-bold\"><span uk-icon=\"icon: info\">&nbsp;</span> Information:</span> Manage access mode &amp; type of selected research results. For OpenAIRE this functionality isn&#39;t available.</div> </div>";
        String portal_footer_content = "<p class=\"uk-margin-remove-bottom\"><span style=\"font-size:12px\">OpenAIRE has received funding from the European Union's Horizon 2020 research and innovation programme under grant agreements No. 777541 and 101017452</span></p>";
        String monitor_dashboard_footer_content = "<p class=\"uk-margin-remove-bottom\"><span style=\"font-size:12px\">This OpenAIRE MONITOR dashboard is part of a project that has received funding from the European Union's Horizon 2020 research and innovation programme under grant agreements No. 777541 and 101017452</span></p>";
        String community_footer_content = "<p class=\"uk-margin-remove-bottom\"><span style=\"font-size:12px\">This OpenAIRE gateway is part of a project that has received funding from the European Union's Horizon 2020 research and innovation programme under grant agreements No. 777541, 731011 and 101017452</span></p>";
        List<DivId> divIds = this.divIdService.getDivIdsByPortalType(PortalType.valueOf(portal.getType()));
        for (DivId div : divIds) {
            if (div == null) continue;
            if (div.getName().equals("link-context-form")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), link_context_form_content, false));
                continue;
            }
            if (div.getName().equals("link-project-form")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), link_project_form_content, false));
                continue;
            }
            if (div.getName().equals("link-result-form")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), link_result_form_content, false));
                continue;
            }
            if (div.getName().equals("link-result-bulk")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), link_result_bulk_content, false));
                continue;
            }
            if (div.getName().equals("link-metadata")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), link_metadata_content, false));
                continue;
            }
            if (!div.getName().equals("footer")) continue;
            if (portal.getType().equals("community")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), community_footer_content, true));
                continue;
            }
            if (portal.getType().equals("funder") || portal.getType().equals("ri") || portal.getType().equals("project") || portal.getType().equals("organization")) {
                this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), monitor_dashboard_footer_content, true));
                continue;
            }
            this.insertOrUpdateDivHelpContent(new DivHelpContent(div.getId(), portal.getId(), portal_footer_content, true));
        }
    }
}

