/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.DivIdDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.DivId;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivIdResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.DivHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DivIdService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private DivIdDAO divIdDAO;
    @Autowired
    private PageService pageService;
    @Autowired
    private DivHelpContentService divHelpContentService;

    public List<DivId> getDivIds(Portal portal, String page, String name) {
        List<Object> divIds = null;
        if (page != null && name != null && portal != null) {
            DivId divId = this.divIdDAO.findByPagesContainingAndNameAndPortalType(page, name, PortalType.valueOf(portal.getType()));
            if (divId != null) {
                divIds = new ArrayList<DivId>();
                divIds.add(divId);
            }
        } else if (page != null && name != null) {
            DivId divId = this.divIdDAO.findByPagesContainingAndName(page, name);
            if (divId != null) {
                divIds = new ArrayList<DivId>();
                divIds.add(divId);
            }
        } else if (page != null && portal != null) {
            divIds = this.divIdDAO.findByPagesContainingAndPortalType(page, PortalType.valueOf(portal.getType()));
        } else if (name != null && portal != null) {
            DivId divId = this.divIdDAO.findByNameAndPortalType(name, PortalType.valueOf(portal.getType()));
            if (divId != null) {
                divIds = new ArrayList();
                divIds.add(divId);
            }
        } else {
            divIds = page != null ? this.divIdDAO.findByPagesContaining(page) : (name != null ? this.divIdDAO.findByName(name) : (portal != null ? this.divIdDAO.findByPortalType(PortalType.valueOf(portal.getType())) : this.divIdDAO.findAll()));
        }
        return divIds;
    }

    public List<DivId> getDivIdsByPortalType(PortalType portalType) {
        return this.divIdDAO.findByPortalType(portalType);
    }

    public List<DivIdResponse> getDivIdsFull(Portal portal, String page, String name) {
        List<DivId> divIds = this.getDivIds(portal, page, name);
        if (divIds == null) {
            return null;
        }
        ArrayList<DivIdResponse> divIdResponses = new ArrayList<DivIdResponse>();
        for (DivId divId : divIds) {
            DivIdResponse divIdResponse = new DivIdResponse(divId);
            ArrayList<Page> pages = new ArrayList<Page>();
            for (String pageId : divId.getPages()) {
                pages.add(this.pageService.getPage(pageId));
            }
            divIdResponse.setPages(pages);
            divIdResponses.add(divIdResponse);
        }
        return divIdResponses;
    }

    public DivId getDivId(String id) {
        return (DivId)this.divIdDAO.findById(id).orElseThrow(() -> new NoSuchElementException("Div id not found: " + id));
    }

    public DivIdResponse getDivIdFull(String id) {
        return this.divIdResponseFromDivId(this.getDivId(id));
    }

    public DivIdResponse divIdResponseFromDivId(DivId divId) {
        DivIdResponse divIdResponse = new DivIdResponse(divId);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (String pageId : divId.getPages()) {
            pages.add(this.pageService.getPage(pageId));
        }
        divIdResponse.setPages(pages);
        return divIdResponse;
    }

    public void deleteAllDivIds() {
        this.divIdDAO.deleteAll();
    }

    public DivId insertOrUpdateDivId(DivId divId) {
        return (DivId)this.divIdDAO.save(divId);
    }

    public DivIdResponse insertDivId(DivIdResponse divIdResponse) {
        DivId divId = this.getDivIdByDivIdResponse(divIdResponse);
        DivId savedDivId = (DivId)this.divIdDAO.save(divId);
        divIdResponse.setId(savedDivId.getId());
        return this.getDivIdFull(divId.getId());
    }

    private DivId getDivIdByDivIdResponse(DivIdResponse divIdResponse) {
        DivId divId = new DivId();
        divId.setId(divIdResponse.getId());
        divId.setName(divIdResponse.getName());
        divId.setPortalType(divIdResponse.getPortalType());
        List<Page> fullPages = divIdResponse.getPages();
        ArrayList<String> pages = new ArrayList<String>();
        for (Page page : fullPages) {
            pages.add(page.getId());
        }
        divId.setPages(pages);
        return divId;
    }

    public DivIdResponse updateDivId(DivIdResponse divIdResponse) {
        DivId divId = this.getDivIdByDivIdResponse(divIdResponse);
        this.divIdDAO.save(divId);
        return divIdResponse;
    }

    public Boolean deleteDivIds(List<String> divIds) {
        for (String id : divIds) {
            for (DivHelpContentResponse divHelpContentResponse : this.divHelpContentService.getDivHelpContents(null, null, id, null)) {
                this.divHelpContentService.deleteDivHelpContent(divHelpContentResponse.getId());
            }
            this.divIdDAO.deleteById(id);
        }
        return true;
    }

    public void deleteDivId(String id) {
        this.divIdDAO.deleteById(id);
    }

    public Set<String> getDivIdsPages(Portal portal) {
        List<DivId> divIds = null;
        HashSet<String> hasPortalPageDivIds = new HashSet<String>();
        divIds = portal != null ? this.divIdDAO.findByPortalType(PortalType.valueOf(portal.getType())) : this.divIdDAO.findAll();
        for (DivId divId : divIds) {
            hasPortalPageDivIds.addAll(divId.getPages());
        }
        return hasPortalPageDivIds;
    }
}

