/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.AdminToolsProperties;
import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.Google;
import eu.dnetlib.uoaadmintoolslibrary.configuration.properties.Mail;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.GoogleResponse;
import eu.dnetlib.uoaadmintoolslibrary.exceptions.InvalidReCaptchaException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class EmailService {
    private static final Logger logger = LogManager.getLogger(EmailService.class);
    private final JavaMailSender mailSender;
    private final AdminToolsProperties properties;
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("[A-Za-z0-9_-]+");
    private final RestTemplate restTemplate;

    @Autowired
    public EmailService(JavaMailSender mailSender, AdminToolsProperties properties, RestTemplate restTemplate) {
        this.mailSender = mailSender;
        this.properties = properties;
        this.restTemplate = restTemplate;
    }

    public boolean send(List<String> recipients, String subject, String body, Boolean bcc) {
        Mail mail = this.properties.getMail();
        logger.debug("Try to connect to mail sender with {}", (Object)mail.getUsername());
        try {
            logger.debug("Try to sent e-mail to {}\nSubject: {}\nBody:{}", (Object)recipients.toString(), (Object)subject, (Object)body);
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(new InternetAddress(mail.getFrom()));
            ArrayList<String> bccRecipients = new ArrayList<String>(Collections.singletonList(mail.getFrom()));
            if (!bcc.booleanValue()) {
                helper.setTo(recipients.toArray(new String[0]));
            } else {
                bccRecipients.addAll(recipients);
            }
            helper.setBcc(bccRecipients.toArray(new String[0]));
            helper.setSubject(subject);
            helper.setText(body, true);
            this.mailSender.send(message);
            logger.debug("Sent message successfully....\n");
            return true;
        }
        catch (Exception e) {
            logger.error("Email could not be sent.", (Throwable)e);
            return false;
        }
    }

    public void processResponse(String response) {
        Google google = this.properties.getGoogle();
        if (!this.responseSanityCheck(response)) {
            InvalidReCaptchaException e = new InvalidReCaptchaException("Response contains invalid characters");
            logger.error("Response contains invalid characters", (Throwable)((Object)e));
            throw e;
        }
        URI verifyUri = URI.create(String.format("https://www.google.com/recaptcha/api/siteverify?secret=%s&response=%s", google.getSecret(), response));
        GoogleResponse googleResponse = (GoogleResponse)this.restTemplate.getForObject(verifyUri, GoogleResponse.class);
        assert (googleResponse != null);
        if (!googleResponse.isSuccess()) {
            logger.error("Has client error:{}", (Object)googleResponse.hasClientError());
            InvalidReCaptchaException e = new InvalidReCaptchaException("reCaptcha was not successfully validated");
            logger.error("reCaptcha was not successfully validated", (Throwable)((Object)e));
            throw e;
        }
    }

    private boolean responseSanityCheck(String response) {
        return StringUtils.hasLength((String)response) && RESPONSE_PATTERN.matcher(response).matches();
    }
}

