/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.PageHelpContentDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.PageHelpContent;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PageHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageHelpContentService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PageHelpContentDAO pageHelpContentDAO;
    @Autowired
    private PageService pageService;
    @Autowired
    private PortalService portalService;

    public List<PageHelpContentResponse> getPageHelpContents(Portal portal) {
        return this.getPageHelpContents(portal, null, null, null, null);
    }

    public List<PageHelpContentResponse> getPageHelpContents(Portal portal, String page, String position, String active, String before) {
        List<PageHelpContent> pageHelpContents = null;
        pageHelpContents = portal != null && position != null && active != null && before != null ? this.pageHelpContentDAO.findByPortalAndPlacementAndIsActiveAndIsPriorToOrderByOrderAsc(portal.getId(), position, Boolean.parseBoolean(active), Boolean.parseBoolean(before)) : (portal != null && position != null && active != null ? this.pageHelpContentDAO.findByPortalAndPlacementAndIsActiveOrderByOrderAsc(portal.getId(), position, Boolean.parseBoolean(active)) : (portal != null && position != null && before != null ? this.pageHelpContentDAO.findByPortalAndPlacementAndIsPriorToOrderByOrderAsc(portal.getId(), position, Boolean.parseBoolean(before)) : (portal != null && active != null && before != null ? this.pageHelpContentDAO.findByPortalAndIsActiveAndIsPriorToOrderByPlacementAscOrderAsc(portal.getId(), Boolean.parseBoolean(active), Boolean.parseBoolean(before)) : (position != null && active != null && before != null ? this.pageHelpContentDAO.findByPlacementAndIsActiveAndIsPriorToOrderByOrderAsc(position, Boolean.parseBoolean(active), Boolean.parseBoolean(before)) : (portal != null && position != null ? this.pageHelpContentDAO.findByPortalAndPlacementOrderByOrderAsc(portal.getId(), position) : (portal != null && active != null ? this.pageHelpContentDAO.findByPortalAndIsActiveOrderByPlacementAscOrderAsc(portal.getId(), Boolean.parseBoolean(active)) : (portal != null && before != null ? this.pageHelpContentDAO.findByPortalAndIsPriorToOrderByPlacementAscOrderAsc(portal.getId(), Boolean.parseBoolean(before)) : (position != null && active != null ? this.pageHelpContentDAO.findByPlacementAndIsActiveOrderByOrderAsc(position, Boolean.parseBoolean(active)) : (position != null && before != null ? this.pageHelpContentDAO.findByPlacementAndIsPriorToOrderByOrderAsc(position, Boolean.parseBoolean(before)) : (active != null && before != null ? this.pageHelpContentDAO.findByIsActiveAndIsPriorToOrderByPlacementAscOrderAsc(Boolean.parseBoolean(active), Boolean.parseBoolean(before)) : (portal != null ? this.pageHelpContentDAO.findByPortalOrderByPlacementAscOrderAsc(portal.getId()) : (position != null ? this.pageHelpContentDAO.findByPlacementOrderByOrderAsc(position) : (active != null ? this.pageHelpContentDAO.findByIsActiveOrderByPlacementAscOrderAsc(Boolean.parseBoolean(active)) : (before != null ? this.pageHelpContentDAO.findByIsPriorToOrderByPlacementAscOrderAsc(Boolean.parseBoolean(before)) : this.pageHelpContentDAO.findAllByOrderByPlacementAscOrderAsc()))))))))))))));
        ArrayList<PageHelpContentResponse> pageHelpContentResponses = new ArrayList<PageHelpContentResponse>();
        for (PageHelpContent pageHelpContent : pageHelpContents) {
            Page _page = this.pageService.getPage(pageHelpContent.getPage());
            if (page != null && !page.equals(_page.getRoute()) || portal != null && !portal.getType().equals(_page.getPortalType())) continue;
            PageHelpContentResponse pageHelpContentResponse = new PageHelpContentResponse(pageHelpContent);
            pageHelpContentResponse.setPage(_page);
            pageHelpContentResponse.setPortal(this.portalService.getPortalById(pageHelpContent.getPortal()));
            pageHelpContentResponses.add(pageHelpContentResponse);
        }
        return pageHelpContentResponses;
    }

    public List<PageHelpContent> getPageHelpContentsBasic(Portal portal, String pageId) {
        List<PageHelpContent> pageHelpContents = null;
        pageHelpContents = portal != null && pageId != null ? this.pageHelpContentDAO.findByPortalAndPageOrderByPlacementAscOrderAsc(portal.getId(), pageId) : (portal != null ? this.pageHelpContentDAO.findByPortalOrderByPlacementAscOrderAsc(portal.getId()) : this.pageHelpContentDAO.findAllByOrderByPlacementAscOrderAsc());
        return pageHelpContents;
    }

    public void deleteAllPageHelpContents() {
        this.pageHelpContentDAO.deleteAll();
    }

    public PageHelpContent insertOrUpdatePageHelpContent(PageHelpContent pageHelpContent) {
        return (PageHelpContent)this.pageHelpContentDAO.save(pageHelpContent);
    }

    public PageHelpContent getPageHelpContent(String id) {
        return (PageHelpContent)this.pageHelpContentDAO.findById(id).orElseThrow(() -> new NotFoundException("Could not find PageHelpContent with id: " + id));
    }

    public List<String> togglePageHelpContent(Portal portal, List<String> pageHelpContents, String status) {
        for (String id : pageHelpContents) {
            PageHelpContent pageHelpContent = this.getPageHelpContent(id);
            if (!pageHelpContent.getPortal().equals(portal.getId())) {
                throw new MismatchingContentException("[" + portal.getType() + " - " + portal.getPid() + "] Conflicting page help content: portal id: " + pageHelpContent.getPortal());
            }
            pageHelpContent.setIsActive(Boolean.parseBoolean(status));
            this.pageHelpContentDAO.save(pageHelpContent);
        }
        return pageHelpContents;
    }

    public void deletePageHelpContent(String id) {
        this.pageHelpContentDAO.deleteById(id);
    }

    public Boolean deletePageHelpContents(Portal portal, List<String> pageHelpContents) {
        for (String id : pageHelpContents) {
            PageHelpContent pageHelpContent = this.getPageHelpContent(id);
            if (!pageHelpContent.getPortal().equals(portal.getId())) {
                throw new MismatchingContentException("[" + portal.getType() + " - " + portal.getPid() + "] Conflicting page help content: portal id: " + pageHelpContent.getPortal());
            }
            this.pageHelpContentDAO.deleteById(id);
        }
        return true;
    }

    public void addPageHelpContentsInPortal(Portal portal) {
        Page depositLearnHowPage;
        Page organizationsPage = this.pageService.getPageByPortalAndRoute(portal, "/organizations");
        if (organizationsPage != null) {
            String organizations_page_content = "<div> <p>Here you can write more details about the organizations related to your community.</p> </div>";
            PageHelpContent organizations_pageHelpContent = new PageHelpContent(organizationsPage.getId(), portal.getId(), "top", 1, organizations_page_content, false, false);
            this.pageHelpContentDAO.save(organizations_pageHelpContent);
        }
        if ((depositLearnHowPage = this.pageService.getPageByPortalAndRoute(portal, "/participate/deposit/learn-how")) != null) {
            String depositLearnHow_page_content = "<div class=\"uk-width-3-5 uk-align-center\">  <div class=\"uk-text-bold\">How to comply with funder Open Access policies</div>  <ul class=\"uk-list uk-list-bullet\">    <li>Read the <a href=\"https://www.openaire.eu/how-to-comply-to-h2020-mandates-for-publications\" target=\"_blank\"> <span>OpenAIRE guide to learn how to comply with EC H2020 Open Access policy on publications>/span> <span class=\"custom-external custom-icon space\"> </span> </a></li>    <li>Read the <a href=\"https://www.openaire.eu/how-to-comply-to-h2020-mandates-for-data\" target=\"_blank\"> <span>OpenAIRE guide to learn how to comply with EC H2020 Open Access policy on research data</span> <span class=\"custom-external custom-icon space\"> </span></a></li>    <li>If you want to know about National Open Access policies, please check them out <a href=\"https://www.openaire.eu/frontpage/country-pages\" target=\"_blank\"><span>here</span> <span class=\"custom-external custom-icon space\"> </span></a></li>    <li>All OpenAIRE guides can be found <a href=\"https://www.openaire.eu/guides\" target=\"_blank\"><span>here</span> <span class=\"custom-external custom-icon space\"> </span></a></li>  </ul> </div>";
            PageHelpContent depositLearnHow_pageHelpContent = new PageHelpContent(depositLearnHowPage.getId(), portal.getId(), "bottom", 1, depositLearnHow_page_content, true, false);
            this.pageHelpContentDAO.save(depositLearnHow_pageHelpContent);
        }
    }
}

