/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.PageDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.DivId;
import eu.dnetlib.uoaadmintoolslibrary.entities.Entity;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PageHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalPage;
import eu.dnetlib.uoaadmintoolslibrary.services.DivHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.DivIdService;
import eu.dnetlib.uoaadmintoolslibrary.services.EntityService;
import eu.dnetlib.uoaadmintoolslibrary.services.PageHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.RolesUtils;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.ForbiddenException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private PageDAO pageDAO;
    @Autowired
    private PortalService portalService;
    @Autowired
    private PageHelpContentService pageHelpContentService;
    @Autowired
    private DivHelpContentService divHelpContentService;
    @Autowired
    private DivIdService divIdService;
    @Autowired
    private EntityService entityService;

    public List<PortalPage> getPagesFull(Portal portal, String pageRoute) {
        List<Page> pages = this.getAllPages(portal, pageRoute, null);
        if (pages == null) {
            return null;
        }
        ArrayList<PortalPage> portalPages = new ArrayList<PortalPage>();
        for (Page page : pages) {
            PortalPage portalPage = new PortalPage(page);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (String entityId : page.getEntities()) {
                entities.add(this.entityService.getEntity(entityId));
            }
            portalPage.setEntities(entities);
            portalPages.add(portalPage);
        }
        return portalPages;
    }

    public List<Page> getAllPages(Portal portal, String pageRoute, String withPositions) {
        List<Object> pages = null;
        if (portal != null) {
            if (pageRoute != null) {
                pages = new ArrayList();
                Page page = this.pageDAO.findByPortalTypeAndRouteAndPortalPidOrNull(portal.getType(), pageRoute, portal.getPid());
                if (page != null) {
                    pages.add(page);
                }
            } else {
                pages = this.pageDAO.findByPortalTypeAndPortalPidOrNull(portal.getType(), portal.getPid());
            }
        } else {
            pages = pageRoute != null ? this.pageDAO.findByRoute(pageRoute) : this.pageDAO.findAll();
        }
        if (withPositions != null) {
            if (pages == null) {
                return null;
            }
            boolean at_least_one_position = Boolean.parseBoolean(withPositions);
            Iterator iteratorPages = pages.iterator();
            while (iteratorPages.hasNext()) {
                Page page = (Page)iteratorPages.next();
                if (at_least_one_position) {
                    if (page.getTop().booleanValue() || page.getBottom().booleanValue() || page.getLeft().booleanValue() || page.getRight().booleanValue()) continue;
                    iteratorPages.remove();
                    continue;
                }
                if (!page.getTop().booleanValue() && !page.getBottom().booleanValue() && !page.getLeft().booleanValue() && !page.getRight().booleanValue()) continue;
                iteratorPages.remove();
            }
        }
        if (pages != null) {
            pages.sort(Comparator.comparing(Page::getName));
        }
        return pages;
    }

    public List<Page> getPagesByPortal(Portal portal) {
        return this.pageDAO.findByPortalTypeAndPortalPidOrNull(portal.getType(), portal.getPid());
    }

    public Page getPageByPortalAndRoute(Portal portal, String pageRoute) {
        if (pageRoute == null || portal == null) {
            return null;
        }
        return this.pageDAO.findByPortalTypeAndRouteAndPortalPidOrNull(portal.getType(), pageRoute, portal.getPid());
    }

    public void deleteAllPages() {
        this.pageDAO.deleteAll();
    }

    public Page insertOrUpdatePage(Page page) {
        return (Page)this.pageDAO.save(page);
    }

    public PortalPage updatePage(PortalPage portalPage) {
        this.deletePageHelpContentsForPositionsIfDisabled(portalPage);
        Page page = this.getPageByPortalPage(portalPage);
        this.pageDAO.save(page);
        return portalPage;
    }

    public PortalPage insertPage(PortalPage portalPage) {
        List<Portal> portals = null;
        if (portalPage.getPortalPid() == null) {
            portals = this.portalService.getAllPortalsByType(portalPage.getPortalType());
        } else {
            Portal portal = this.portalService.getPortal(PortalType.valueOf(portalPage.getPortalType()), portalPage.getPortalPid());
            portals = new ArrayList<Portal>();
            portals.add(portal);
        }
        if (portals == null || portals.isEmpty()) {
            throw new NotFoundException("No portals found with type: " + portalPage.getPortalType());
        }
        Page page = this.getPageByPortalPage(portalPage);
        Page savedPage = (Page)this.pageDAO.save(page);
        portalPage.setId(savedPage.getId());
        for (Portal portal : portals) {
            Map<String, Boolean> pages = portal.getPages();
            pages.put(page.getId(), false);
            portal.setPages(pages);
            this.portalService.insertOrUpdatePortal(portal);
        }
        return portalPage;
    }

    private Page getPageByPortalPage(PortalPage portalPage) {
        Page page = new Page();
        page.setId(portalPage.getId());
        page.setRoute(portalPage.getRoute());
        page.setName(portalPage.getName());
        page.setType(portalPage.getType());
        page.setPortalType(portalPage.getPortalType());
        page.setPortalPid(portalPage.getPortalPid());
        page.setTop(portalPage.getTop());
        page.setBottom(portalPage.getBottom());
        page.setLeft(portalPage.getLeft());
        page.setRight(portalPage.getRight());
        List<Entity> fullEntities = portalPage.getEntities();
        ArrayList<String> entities = new ArrayList<String>();
        for (Entity entity : fullEntities) {
            entities.add(entity.getId());
        }
        page.setEntities(entities);
        return page;
    }

    private void deletePageHelpContentsForPositionsIfDisabled(PortalPage portalPage) {
        List<PageHelpContentResponse> pageHelpContentResponses;
        Portal portal = this.portalService.getPortal(PortalType.valueOf(portalPage.getPortalType()), portalPage.getPortalPid());
        if (!portalPage.getTop().booleanValue()) {
            pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, portalPage.getRoute(), "top", null, null);
            for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
                this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
            }
        }
        if (!portalPage.getBottom().booleanValue()) {
            pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, portalPage.getRoute(), "bottom", null, null);
            for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
                this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
            }
        }
        if (!portalPage.getLeft().booleanValue()) {
            pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, portalPage.getRoute(), "left", null, null);
            for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
                this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
            }
        }
        if (!portalPage.getRight().booleanValue()) {
            pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, portalPage.getRoute(), "right", null, null);
            for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
                this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
            }
        }
    }

    public Boolean deletePages(List<String> pages) {
        for (String id : pages) {
            Page page = this.getPage(id);
            Portal portal = this.portalService.getPortal(PortalType.valueOf(page.getPortalType()), page.getPortalPid());
            if (!this.rolesUtils.isPortalAdmin() || page.getPortalPid() != null && this.rolesUtils.hasUpdateAuthority(page.getPortalType(), page.getPortalPid())) {
                throw new ForbiddenException("Delete page: You are not authorized to delete a page for " + page.getPortalType() + (String)(page.getPortalPid() != null ? " : " + page.getPortalPid() : ""));
            }
            List<DivId> divIds = this.divIdService.getDivIds(portal, page.getId(), null);
            for (DivId divId : divIds) {
                if (divId.getPages().size() == 1) {
                    List<DivHelpContentResponse> divHelpContentResponses = this.divHelpContentService.getDivHelpContents(portal, page.getRoute(), divId.getId(), null);
                    for (DivHelpContentResponse divHelpContentResponse : divHelpContentResponses) {
                        this.divHelpContentService.deleteDivHelpContent(divHelpContentResponse.getId());
                    }
                    this.divIdService.deleteDivId(divId.getId());
                    continue;
                }
                List<String> divIdPages = divId.getPages();
                divIdPages.remove(id);
                divId.setPages(divIdPages);
                this.divIdService.insertOrUpdateDivId(divId);
            }
            List<PageHelpContentResponse> pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, page.getRoute(), null, null, null);
            for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
                this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
            }
            List<Portal> list = portal != null ? Collections.singletonList(portal) : this.portalService.getAllPortalsByType(page.getPortalType());
            list.forEach(p -> {
                Map<String, Boolean> portalPages = p.getPages();
                portalPages.remove(id);
                p.setPages(portalPages);
                this.portalService.insertOrUpdatePortal((Portal)p);
            });
            this.pageDAO.deleteById(id);
        }
        return true;
    }

    public Page getPage(Portal portal, String id) {
        return this.pageDAO.findByIdAndPortalTypeAndPortalPidOrNull(id, PortalType.valueOf(portal.getType()), portal.getPid()).orElseThrow(() -> new NotFoundException("getPage: no page with id: " + id + " and portal: [" + portal.getType() + "-" + portal.getPid() + "]"));
    }

    public Page getPage(String id) {
        return (Page)this.pageDAO.findById(id).orElseThrow(() -> new NotFoundException("getPage: no page with id: " + id));
    }

    public void deletePage(String id) {
        this.pageDAO.deleteById(id);
    }

    public List<String> getPageEntities(String id) {
        return this.getPage(id).getEntities();
    }

    public Page togglePageEntity(String id, String entityId, String status) {
        this.log.debug("Toggle entity : " + entityId + " of page: " + id + " to " + status);
        Page page = this.getPage(id);
        List<String> entities = page.getEntities();
        if (Boolean.parseBoolean(status) && !entities.contains(entityId)) {
            entities.add(entityId);
        } else if (!Boolean.parseBoolean(status)) {
            entities.remove(entityId);
        }
        page.setEntities(entities);
        return (Page)this.pageDAO.save(page);
    }

    public void updatePid(String oldPid, Portal portal) {
        this.log.debug("page service: updatePid");
        List<Page> pages = this.pageDAO.findByPortalTypeAndPortalPidOrNull(portal.getType(), oldPid);
        for (Page page : pages) {
            if (page == null) continue;
            page.setPortalPid(portal.getPid());
            this.pageDAO.save(page);
            this.log.debug("page " + page.getId() + " saved!");
        }
    }
}

