/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.services;

import eu.dnetlib.uoaadmintoolslibrary.dao.PortalDAO;
import eu.dnetlib.uoaadmintoolslibrary.entities.DivId;
import eu.dnetlib.uoaadmintoolslibrary.entities.Entity;
import eu.dnetlib.uoaadmintoolslibrary.entities.Page;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.PortalType;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.DivHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PageHelpContentResponse;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalEntity;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalPage;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.DivHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.DivIdService;
import eu.dnetlib.uoaadmintoolslibrary.services.EntityService;
import eu.dnetlib.uoaadmintoolslibrary.services.PageHelpContentService;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortalService {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    private PortalDAO portalDAO;
    @Autowired
    private PageService pageService;
    @Autowired
    private EntityService entityService;
    @Autowired
    private DivIdService divIdService;
    @Autowired
    private PageHelpContentService pageHelpContentService;
    @Autowired
    private DivHelpContentService divHelpContentService;

    public List<Portal> getAllPortals() {
        return this.portalDAO.findAll();
    }

    public List<Portal> getAllPortalsByType(String type) {
        return this.portalDAO.findByType(PortalType.valueOf(type));
    }

    public List<PortalResponse> getPortalsFull(List<Portal> portals) {
        ArrayList<PortalResponse> portalsResponse = new ArrayList<PortalResponse>();
        for (Portal portal : portals) {
            PortalResponse portalResponse = new PortalResponse(portal);
            this.setEnabledPagesForPortalByType(portal, portalResponse);
            this.setEnabledEntitiesForPortalByType(portal, portalResponse);
            portalsResponse.add(portalResponse);
        }
        return portalsResponse;
    }

    public List<PortalResponse> getAllPortalsFull() {
        List<Portal> portals = this.getAllPortals();
        return this.getPortalsFull(portals);
    }

    public List<PortalResponse> getAllPortalsFullByType(String type) {
        List<Portal> portals = this.getAllPortalsByType(type);
        return this.getPortalsFull(portals);
    }

    private void setEnabledPagesForPortalByType(Portal portal, PortalResponse portalResponse) {
        List<PortalPage> pages = this.getPagesForPortalByType(portal, null, null, null, null);
        pages.removeIf(page -> page.getIsEnabled() == false);
        portalResponse.setPages(pages);
    }

    private void setEnabledEntitiesForPortalByType(Portal portal, PortalResponse portalResponse) {
        List<PortalEntity> entities = this.getEntitiesForPortal(portal, null);
        entities.removeIf(entity -> entity.getIsEnabled() == false);
        portalResponse.setEntities(entities);
    }

    public Portal getPortal(String pid) {
        return this.portalDAO.findByPid(pid).orElse(null);
    }

    public Portal getPortal(String pid, Boolean exception) {
        if (exception.booleanValue()) {
            return this.portalDAO.findByPid(pid).orElseThrow(() -> new NotFoundException("Could not find portal with pid " + pid));
        }
        return this.getPortal(pid);
    }

    public Portal getPortal(PortalType type, String pid) {
        return this.portalDAO.findByTypeAndPid(type, pid).orElse(null);
    }

    public Portal getPortal(PortalType type, String pid, Boolean exception) {
        if (exception.booleanValue()) {
            return this.portalDAO.findByTypeAndPid(type, pid).orElseThrow(() -> new NotFoundException("Could not find portal with type: " + String.valueOf((Object)type) + " and pid " + pid));
        }
        return this.getPortal(type, pid);
    }

    public Portal getPortalById(String id) {
        return (Portal)this.portalDAO.findById(id).orElseThrow(() -> new NotFoundException("Portal with id " + id + " not found"));
    }

    public PortalResponse getPortalFull(Portal portal) {
        PortalResponse portalResponse = new PortalResponse(portal);
        this.setEnabledPagesForPortalByType(portal, portalResponse);
        this.setEnabledEntitiesForPortalByType(portal, portalResponse);
        return portalResponse;
    }

    public PortalResponse updatePortal(Portal portal) {
        Portal saved = this.getPortalById(portal.getId());
        String oldPid = saved.getPid();
        saved.setName(portal.getName());
        saved.setPid(portal.getPid());
        saved.setPiwik(portal.getPiwik());
        saved.setTwitterAccount(portal.getTwitterAccount());
        portal = (Portal)this.portalDAO.save(saved);
        if (!oldPid.equals(portal.getPid())) {
            this.pageService.updatePid(oldPid, portal);
        }
        return this.getPortalFull(portal);
    }

    public PortalResponse insertPortal(Portal portal) {
        HashMap<String, Boolean> entities = new HashMap<String, Boolean>();
        HashMap<String, Boolean> pages = new HashMap<String, Boolean>();
        for (Entity entity : this.entityService.getAllEntities()) {
            entities.put(entity.getId(), true);
            PortalEntity portalEntity = new PortalEntity(entity);
            portalEntity.setIsEnabled(true);
        }
        for (Page page : this.pageService.getPagesByPortal(portal)) {
            pages.put(page.getId(), true);
            PortalPage portalPage = new PortalPage(page);
            if (page.getRoute().equals("/curators") || page.getRoute().equals("/organizations")) {
                portalPage.setIsEnabled(false);
                continue;
            }
            portalPage.setIsEnabled(true);
        }
        portal.setEntities(entities);
        portal.setPages(pages);
        Portal savedPortal = (Portal)this.portalDAO.save(portal);
        PortalResponse portalResponse = this.getPortalFull(savedPortal);
        this.divHelpContentService.addDivHelpContentsInPortal(savedPortal);
        this.pageHelpContentService.addPageHelpContentsInPortal(savedPortal);
        return portalResponse;
    }

    private Portal getPortalByPortalResponse(PortalResponse portalResponse) {
        Portal portal = new Portal();
        portal.setId(portalResponse.getId());
        portal.setName(portalResponse.getName());
        List<PortalEntity> fullEntities = portalResponse.getEntities();
        HashMap<String, Boolean> entities = new HashMap<String, Boolean>();
        for (PortalEntity portalEntity : fullEntities) {
            entities.put(portalEntity.getId(), true);
        }
        for (Entity entity : this.entityService.getAllEntities()) {
            if (entities.containsKey(entity.getId())) continue;
            entities.put(entity.getId(), false);
        }
        portal.setEntities(entities);
        List<PortalPage> fullPages = portalResponse.getPages();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (PortalPage portalPage : fullPages) {
            hashMap.put(portalPage.getId(), true);
        }
        for (Page page : this.pageService.getAllPages(null, null, null)) {
            if (hashMap.containsKey(page.getId())) continue;
            hashMap.put(page.getId(), false);
        }
        portal.setPages(hashMap);
        return portal;
    }

    public Boolean deletePortals(List<String> portals) {
        for (String id : portals) {
            Portal portal = this.getPortalById(id);
            List<DivHelpContentResponse> divHelpContentResponses = this.divHelpContentService.getDivHelpContents(portal, null, null, null);
            for (DivHelpContentResponse divHelpContentResponse : divHelpContentResponses) {
                this.divHelpContentService.deleteDivHelpContent(divHelpContentResponse.getId());
            }
            List<PageHelpContentResponse> pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, null, null, null, null);
            for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
                this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
            }
            this.portalDAO.deleteById(id);
        }
        return true;
    }

    public String deletePortal(String id) {
        Portal portal = this.getPortalById(id);
        List<DivHelpContentResponse> divHelpContentResponses = this.divHelpContentService.getDivHelpContents(portal, null, null, null);
        for (DivHelpContentResponse divHelpContentResponse : divHelpContentResponses) {
            this.divHelpContentService.deleteDivHelpContent(divHelpContentResponse.getId());
        }
        List<PageHelpContentResponse> pageHelpContentResponses = this.pageHelpContentService.getPageHelpContents(portal, null, null, null, null);
        for (PageHelpContentResponse pageHelpContentResponse : pageHelpContentResponses) {
            this.pageHelpContentService.deletePageHelpContent(pageHelpContentResponse.getId());
        }
        List<Portal> list = this.portalDAO.findByType(PortalType.valueOf(portal.getType()));
        if (list == null || list.size() == 1) {
            for (String pageId : portal.getPages().keySet()) {
                this.pageService.deletePage(pageId);
            }
            List<DivId> list2 = this.divIdService.getDivIdsByPortalType(PortalType.valueOf(portal.getType()));
            for (DivId divId : list2) {
                this.divIdService.deleteDivId(divId.getId());
            }
        }
        this.portalDAO.deleteById(id);
        return portal.getPid();
    }

    public void insertOrUpdatePortal(Portal portal) {
        this.portalDAO.save(portal);
    }

    public void deletePortalId(String id) {
        this.portalDAO.deleteById(id);
    }

    public List<PortalPage> getPagesForPortalByType(Portal portal, String page_type, String page_route, String div, String with_positions) {
        ArrayList<PortalPage> return_pages = new ArrayList<PortalPage>();
        Map<String, Boolean> pages = portal.getPages();
        if (pages != null) {
            for (Map.Entry<String, Boolean> page : pages.entrySet()) {
                boolean at_least_one_position;
                if (div != null && div.equals("true")) {
                    List<DivId> divIds = this.divIdService.getDivIds(portal, null, null);
                    divIds.removeIf(divId -> !portal.getType().equals(divId.getPortalType()));
                    if (divIds.isEmpty()) continue;
                }
                Page p = this.pageService.getPage(page.getKey());
                if (with_positions != null && (!(at_least_one_position = Boolean.parseBoolean(with_positions)) ? p.getTop() != false || p.getBottom() != false || p.getLeft() != false || p.getRight() != false : p.getTop() == false && p.getBottom() == false && p.getLeft() == false && p.getRight() == false)) continue;
                if (!portal.getType().equals(p.getPortalType()) || !(page_type == null && page_route == null || page_route == null && p.getType().equals(page_type)) && !p.getRoute().equals(page_route)) continue;
                PortalPage portalPage = new PortalPage(p);
                ArrayList<Entity> entities = new ArrayList<Entity>();
                for (String entity : p.getEntities()) {
                    entities.add(this.entityService.getEntity(entity));
                }
                portalPage.setEntities(entities);
                portalPage.setIsEnabled(page.getValue());
                return_pages.add(portalPage);
                if (page_route == null) continue;
                break;
            }
        }
        return_pages.sort(Comparator.comparing(PortalPage::getName));
        return return_pages;
    }

    public Portal insertOrUpdatePage(String id, PortalPage page) {
        Portal portal = this.getPortalById(id);
        Map<String, Boolean> pages = portal.getPages();
        String name = page.getName();
        boolean isEnabled = page.getIsEnabled();
        pages.put(name, isEnabled);
        portal.setPages(pages);
        return (Portal)this.portalDAO.save(portal);
    }

    public Portal togglePage(Portal portal, List<String> pageIds, String status) {
        Map<String, Boolean> pages = portal.getPages();
        for (String pageId : pageIds) {
            Page page = this.pageService.getPage(pageId);
            if (!page.getPortalType().equals(portal.getType())) {
                throw new MismatchingContentException("[" + portal.getType() + " - " + portal.getPid() + "] Conflicting page type: " + page.getPortalType());
            }
            pages.put(pageId, Boolean.parseBoolean(status));
        }
        portal.setPages(pages);
        return (Portal)this.portalDAO.save(portal);
    }

    public Portal toggleEntity(Portal portal, List<String> entityIds, String status) {
        Map<String, Boolean> entities = portal.getEntities();
        Map<String, Boolean> pages = portal.getPages();
        for (String entityId : entityIds) {
            entities.put(entityId, Boolean.parseBoolean(status));
            if (pages == null) continue;
            for (Map.Entry<String, Boolean> pageEntry : pages.entrySet()) {
                Page page = this.pageService.getPage(pageEntry.getKey());
                if (!page.getEntities().contains(entityId) || !page.getType().equals("search")) continue;
                pages.put(pageEntry.getKey(), Boolean.parseBoolean(status));
            }
        }
        portal.setEntities(entities);
        return (Portal)this.portalDAO.save(portal);
    }

    public List<PortalEntity> getEntitiesForPortal(@NotNull Portal portal) {
        return this.getEntitiesForPortal(portal, null);
    }

    public List<PortalEntity> getEntitiesForPortal(@NotNull Portal portal, String entity) {
        ArrayList<PortalEntity> return_entities = new ArrayList<PortalEntity>();
        Map<String, Boolean> entities = portal.getEntities();
        if (entity != null) {
            Entity _entity = this.entityService.getEntityByPid(entity);
            String entityId = _entity.getId();
            PortalEntity portalEntity = new PortalEntity(_entity);
            portalEntity.setIsEnabled(entities.get(entityId));
            return_entities.add(portalEntity);
        } else if (entities != null) {
            for (Map.Entry<String, Boolean> _entity : entities.entrySet()) {
                PortalEntity portalEntity = new PortalEntity(this.entityService.getEntity(_entity.getKey()));
                portalEntity.setIsEnabled(_entity.getValue());
                return_entities.add(portalEntity);
            }
        }
        return return_entities;
    }

    public Map<String, List<PageHelpContentResponse>> getPageHelpContentsByPosition(Portal portal, String page, String active) {
        HashMap<String, List<PageHelpContentResponse>> pageHelpContentResponses = new HashMap<String, List<PageHelpContentResponse>>();
        List<PageHelpContentResponse> pageHelpContents = null;
        pageHelpContents = this.pageHelpContentService.getPageHelpContents(portal, page, null, active, null);
        pageHelpContentResponses.put("top", new ArrayList());
        pageHelpContentResponses.put("bottom", new ArrayList());
        pageHelpContentResponses.put("left", new ArrayList());
        pageHelpContentResponses.put("right", new ArrayList());
        for (PageHelpContentResponse pageHelpContentResponse : pageHelpContents) {
            ((List)pageHelpContentResponses.get(pageHelpContentResponse.getPlacement())).add(pageHelpContentResponse);
        }
        return pageHelpContentResponses;
    }

    public Map<String, List<DivHelpContentResponse>> getDivHelpContentsByPosition(Portal portal, String page, String active) {
        HashMap<String, List<DivHelpContentResponse>> divHelpContentResponses = new HashMap<String, List<DivHelpContentResponse>>();
        List<DivHelpContentResponse> divHelpContents = null;
        divHelpContents = this.divHelpContentService.getDivHelpContents(portal, page, null, active);
        for (DivHelpContentResponse divHelpContentResponse : divHelpContents) {
            if (!divHelpContentResponses.containsKey(divHelpContentResponse.getDivId().getId())) {
                divHelpContentResponses.put(divHelpContentResponse.getDivId().getName(), new ArrayList());
            }
            ((List)divHelpContentResponses.get(divHelpContentResponse.getDivId().getName())).add(divHelpContentResponse);
        }
        return divHelpContentResponses;
    }
}

