/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.utils;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.http.HttpHeaders;
import org.springframework.util.DigestUtils;

public class ResponseHelper {
    public static String generateETag(String content) {
        String hash = DigestUtils.md5DigestAsHex((byte[])content.getBytes());
        return "\"" + hash + "\"";
    }

    public static HttpHeaders getCacheHeadersWithTag(String response, Date date) {
        HttpHeaders headers = new HttpHeaders();
        headers.setETag(ResponseHelper.generateETag(response));
        headers.setCacheControl("max-age=3600");
        if (date != null) {
            headers.setLastModified(date.getTime());
        }
        Date now = new Date();
        headers.setExpires(now.getTime() + 3600000L);
        headers.setExpires(now.getTime() + 0x6DDD00L);
        return headers;
    }

    public static void getCacheHeadersWithTag(String response, HttpServletResponse HSResponse, HttpServletRequest request) {
        String tag = ResponseHelper.generateETag(response.toString());
        String ifMatchHeader = request.getHeader("If-Match");
        if (ifMatchHeader != null && ifMatchHeader.equals(tag)) {
            HSResponse.setStatus(304);
        } else {
            Date now = new Date();
            now.setTime(now.getTime() + 3600000L);
            HSResponse.setHeader("ETag", tag);
            HSResponse.setHeader("Cache-Control", "no-cache, max-age=3600");
            HSResponse.setHeader("Expires", ResponseHelper.getvalidHeaderDateFormat(now));
        }
    }

    public static void getCacheHeadersWithTag(String tag, HttpServletResponse HSResponse) {
        Date now = new Date();
        now.setTime(now.getTime() + 3600000L);
        HSResponse.setHeader("ETag", tag);
        HSResponse.setHeader("Cache-Control", "no-cache, max-age=3600");
        HSResponse.setHeader("Expires", ResponseHelper.getvalidHeaderDateFormat(now));
        HSResponse.setHeader("Last-Modified", ResponseHelper.getvalidHeaderDateFormat(new Date(1640995200000L)));
    }

    public static String getvalidHeaderDateFormat(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }
}

