/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintoolslibrary.utils;

import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RolesUtils {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final AuthorizationService authorizationService;

    @Autowired
    public RolesUtils(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public List<String> getRoles() {
        return this.authorizationService.getRoles();
    }

    public String getEmail() {
        return this.authorizationService.getEmail();
    }

    public String getAaiId() {
        return this.authorizationService.getAaiId();
    }

    public boolean isPortalAdmin() {
        List list = this.authorizationService.getRoles();
        Objects.requireNonNull(this.authorizationService);
        return list.contains("PORTAL_ADMINISTRATOR");
    }

    public boolean isCurator(String type) {
        return this.authorizationService.getRoles().contains(this.authorizationService.curator(type));
    }

    public boolean isManager(String type, String id) {
        return this.authorizationService.getRoles().contains(this.authorizationService.manager(type, id));
    }

    public boolean isMember(String type, String id) {
        return this.authorizationService.getRoles().contains(this.authorizationService.member(type, id));
    }

    public boolean isLoggedIn() {
        return this.authorizationService.getAaiId() != null;
    }

    public boolean hasUpdateAuthority(String type, String id) {
        return this.isPortalAdmin() || this.isCurator(type) || this.isManager(type, id);
    }

    public boolean hasCreateAndDeleteAuthority(String type) {
        return this.isPortalAdmin() || this.isCurator(type);
    }
}

