/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.controllers;

import eu.dnetlib.uoaadmintools.entities.Layout;
import eu.dnetlib.uoaadmintools.services.LayoutService;
import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.PageService;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import eu.dnetlib.uoaadmintoolslibrary.utils.MismatchingContentException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/connect"})
public class ConnectController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final LayoutService layoutService;
    @Autowired
    private PortalService portalService;
    @Autowired
    private PageService pageService;

    @Autowired
    public ConnectController(LayoutService layoutService) {
        this.layoutService = layoutService;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> updateConnect(@RequestBody Portal portal) {
        if (!portal.getType().equals("connect")) {
            throw new MismatchingContentException("Update Connect: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of connect");
        }
        String old_pid = this.portalService.getPortalById(portal.getId()).getPid();
        String new_pid = portal.getPid();
        PortalResponse portalResponse = this.portalService.updatePortal(portal);
        if (!old_pid.equals(new_pid)) {
            this.layoutService.updatePid(old_pid, portal);
            this.pageService.updatePid(old_pid, portal);
        }
        return ResponseEntity.ok((Object)portalResponse);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> insertConnect(@RequestBody Portal portal) {
        if (!portal.getType().equals("connect")) {
            throw new MismatchingContentException("Save Connect: Portal with id: " + portal.getId() + " has type: " + portal.getType() + " instead of connect");
        }
        return ResponseEntity.ok((Object)this.portalService.insertPortal(portal));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deleteConnect(@RequestBody List<String> portals) {
        for (String id : portals) {
            Portal portal = this.portalService.getPortalById(id);
            if (!portal.getType().equals("connect")) {
                throw new MismatchingContentException("Delete Connect: Portal with id: " + id + " has type: " + portal.getType() + " instead of connect");
            }
            String pid = this.portalService.deletePortal(id);
            this.layoutService.deleteByPid(pid);
        }
        return ResponseEntity.ok((Object)true);
    }

    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.GET})
    public ResponseEntity<Layout> getLayoutForConnect(@PathVariable(value="pid") String pid) {
        if (!pid.equals("connect") && !pid.equals("default")) {
            throw new MismatchingContentException("ConnectController - Get layout: Not accepted pid: " + pid);
        }
        return ResponseEntity.ok((Object)this.layoutService.findByPid(pid));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.POST})
    public ResponseEntity<Layout> updateLayoutForConnect(@PathVariable(value="pid") String pid, @RequestBody Layout layout) {
        if (!pid.equals("connect") && !pid.equals("default")) {
            throw new MismatchingContentException("ConnectController - Update layout: Not accepted pid: " + pid);
        }
        if (!pid.equals(layout.getPortalPid())) {
            throw new MismatchingContentException("ConnectController - Update layout: Portal has pid: " + pid + " while layout has portalPid: " + layout.getPortalPid());
        }
        return ResponseEntity.ok((Object)this.layoutService.save(layout));
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/{pid}/layout"}, method={RequestMethod.DELETE})
    public ResponseEntity<Boolean> deleteLayoutForConnect(@PathVariable(value="pid") String pid) {
        if (!pid.equals("connect") && !pid.equals("default")) {
            throw new MismatchingContentException("ConnectController - Delete layout: Not accepted pid: " + pid);
        }
        this.layoutService.deleteByPid(pid);
        return ResponseEntity.ok((Object)true);
    }
}

