/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoaadmintools.services;

import eu.dnetlib.uoaadmintools.dao.CuratorDAO;
import eu.dnetlib.uoaadmintools.entities.Manager;
import eu.dnetlib.uoaadmintools.entities.ManagerType;
import eu.dnetlib.uoaadmintools.entities.curator.Curator;
import eu.dnetlib.uoaadmintools.entities.curator.CuratorResponse;
import eu.dnetlib.uoaadmintools.services.ManagerService;
import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CuratorService {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CuratorDAO curatorDAO;
    private final ManagerService managerService;

    @Autowired
    public CuratorService(CuratorDAO curatorDAO, ManagerService managerService) {
        this.curatorDAO = curatorDAO;
        this.managerService = managerService;
    }

    public List<CuratorResponse> getCurators(String pid) {
        ArrayList<CuratorResponse> curators = new ArrayList<CuratorResponse>();
        for (Manager manager : this.managerService.getManagers(pid, ManagerType.ID)) {
            Curator curator = this.curatorDAO.findById((Object)this.parseId(manager.getId())).orElse(null);
            if (curator == null || !curator.isVisible()) continue;
            curators.add(new CuratorResponse(curator));
        }
        return curators;
    }

    public Curator findById(String id) {
        return (Curator)this.curatorDAO.findById((Object)id).orElseThrow(() -> new NotFoundException("Curator with id: " + id + " not found"));
    }

    public Curator save(Curator curator) {
        return (Curator)this.curatorDAO.save((Object)curator);
    }

    public void deleteCurators(String pid) {
        for (Manager manager : this.managerService.getManagers(pid, ManagerType.ID)) {
            this.curatorDAO.findById((Object)this.parseId(manager.getId())).ifPresent(arg_0 -> ((CuratorDAO)this.curatorDAO).delete(arg_0));
        }
    }

    private String parseId(String id) {
        return id.substring(0, id.indexOf("@"));
    }
}

