/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.user.login.registry.beans;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@PropertySource(value={"classpath:eu/dnetlib/openaire/user/login/springContext-userLoginCore.properties"}, ignoreResourceNotFound=false)
@Configuration
@EnableRedisHttpSession
public class Config {
    private static Logger logger = Logger.getLogger(Config.class);
    @Value(value="${redis.host:localhost}")
    private String host;
    @Value(value="${redis.port:6379}")
    private String port;
    @Value(value="${redis.password:#{null}}")
    private String password;
    @Value(value="${webbapp.front.domain:.openaire.eu}")
    private String domain;

    @Bean
    public LettuceConnectionFactory connectionFactory() {
        logger.info((Object)String.format("Redis connection listens to %s:%s ", this.host, this.port));
        LettuceConnectionFactory factory = new LettuceConnectionFactory(this.host, Integer.parseInt(this.port));
        if (this.password != null) {
            factory.setPassword(this.password);
        }
        return factory;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        logger.info((Object)("Cookie Serializer: Domain is " + this.domain));
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("openAIRESession");
        serializer.setCookiePath("/");
        serializer.setDomainName(this.domain);
        return serializer;
    }
}

