/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.configuration;

import eu.dnetlib.authentication.configuration.APIProperties;
import eu.dnetlib.authentication.configuration.Properties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Properties.class, APIProperties.class})
@ComponentScan(basePackages={"eu.dnetlib.authentication"})
public class AuthenticationConfiguration {
    private final Properties properties;

    @Autowired
    public AuthenticationConfiguration(Properties properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authentication.domain", this.properties.getDomain());
        map.put("authentication.keycloak", this.properties.getKeycloak().toString());
        map.put("authentication.redis.host", this.properties.getRedis().getHost());
        map.put("authentication.oidc.issuer", this.properties.getOidc().getIssuer());
        map.put("authentication.oidc.logout", this.properties.getOidc().getLogout());
        map.put("authentication.oidc.home", this.properties.getOidc().getHome());
        map.put("authentication.oidc.redirect", this.properties.getOidc().getRedirect());
        map.put("authentication.oidc.scope", this.properties.getOidc().getScope());
        map.put("authentication.oidc.id", this.properties.getOidc().getId());
        map.put("authentication.oidc.secret", this.properties.getOidc().getSecret());
        map.put("authentication.session", this.properties.getSession());
        map.put("authentication.accessToken", this.properties.getAccessToken());
        map.put("authentication.redirect", this.properties.getRedirect());
        map.put("authentication.authorities-mapper", this.properties.getAuthoritiesMapper());
        return map;
    }
}

