/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.utils;

import eu.dnetlib.authentication.configuration.Properties;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Redirect {
    private static final Logger logger = LogManager.getLogger(Redirect.class);

    private static String getDomain(String url) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        return uriBuilder.getHost();
    }

    public static void setRedirect(HttpServletRequest request, Properties properties) {
        HttpSession session = request.getSession();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            if (!param.equalsIgnoreCase("redirect")) continue;
            String redirect = request.getParameter(param);
            try {
                if (!Redirect.getDomain(redirect).endsWith(properties.getDomain())) continue;
                session.setAttribute("redirect", (Object)redirect);
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

