package eu.dnetlib.authentication.security;

import eu.dnetlib.authentication.configuration.Keycloak;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.services.SecurityService;
import eu.dnetlib.authentication.utils.EntryPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ClientRegistrations;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

@Configuration
public class AuthConfiguration {
    private final Properties properties;
    private final SecurityService service;

    @Autowired
    public AuthConfiguration(Properties properties, SecurityService service) {
        this.properties = properties;
        this.service = service;
    }

    private ClientRegistration getClientRegistration() {
        Keycloak keycloak = this.properties.getKeycloak();
        return ClientRegistrations.fromIssuerLocation(keycloak.getIssuer())
                .registrationId("openaire")
                .clientId(keycloak.getId())
                .clientSecret(keycloak.getSecret())
                .clientName(keycloak.getId())
                .clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC)
                .scope(this.service.getScopes())
                .build();
    }

    @Bean
    public OpenAIREAuthenticationFilter filter() {
        return new OpenAIREAuthenticationFilter(properties);
    }

    @Bean
    public EntryPoint entryPoint() {
        return new EntryPoint();
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(getClientRegistration());
    }

    @Bean
    public OAuth2AuthorizedClientRepository authorizedClientRepository() {
        return new HttpSessionOAuth2AuthorizedClientRepository();
    }

}
