package eu.dnetlib.authentication.utils;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthoritiesMapper {

    private static final Logger logger = LogManager.getLogger(AuthoritiesMapper.class);

    public static Collection<? extends GrantedAuthority> map(ArrayList<String> entitlements) {
        Set<SimpleGrantedAuthority> authorities = new HashSet<>();
        String regex = "urn:geant:openaire[.]eu:group:([^:]*):?(.*)?:role=member#aai[.]openaire[.]eu";
        for(String entitlement : entitlements) {
            Matcher matcher = Pattern.compile(regex).matcher(entitlement);
            if (matcher.find()) {
                authorities.add(new SimpleGrantedAuthority(getAuthority(matcher)));
            }
        }
        return authorities;
    }

    private static String getAuthority(Matcher matcher) {
        StringBuilder sb = new StringBuilder();
        if(matcher.group(1) != null && !matcher.group(1).isEmpty()) {
            sb.append(matcher.group(1).replace("+-+", "_").replaceAll("[+.]", "_").toUpperCase());
        }
        if(!matcher.group(2).isEmpty()) {
            sb.append("_");
            if(matcher.group(2).equals("admins")) {
                sb.append("MANAGER");
            } else  {
                sb.append(matcher.group(2).toUpperCase());
            }
        }
        return sb.toString();
    }
}
