/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.authentication.configuration.GlobalVars;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.utils.PropertyReader;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={Properties.class, GlobalVars.class})
@ComponentScan(basePackages={"eu.dnetlib.authentication"})
public class AuthenticationConfiguration {
    public static String LOGIN_URL = "/openid_connect_login";
    public static String LOGOUT_URL = "/openid_logout";
    private final Properties properties;
    private final GlobalVars globalVars;

    @Autowired
    public AuthenticationConfiguration(Properties properties, GlobalVars globalVars) {
        this.properties = properties;
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.properties.getDomain() == null || this.properties.getDomain().isEmpty()) {
            throw new RuntimeException("authentication.domain is  missing!");
        }
        if (this.properties.getSession() == null || this.properties.getSession().isEmpty()) {
            throw new RuntimeException("authentication.session is  missing!");
        }
        if (this.properties.getRedirect() == null || this.properties.getRedirect().isEmpty()) {
            throw new RuntimeException("authentication.redirect is  missing!");
        }
        if (this.properties.getKeycloak().getName() == null || this.properties.getKeycloak().getName().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.name is  missing!");
        }
        if (this.properties.getKeycloak().getId() == null || this.properties.getKeycloak().getId().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.id is  missing!");
        }
        if (this.properties.getKeycloak().getSecret() == null || this.properties.getKeycloak().getSecret().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.secret is  missing!");
        }
        if (this.properties.getKeycloak().getIssuer() == null || this.properties.getKeycloak().getIssuer().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.issuer is  missing!");
        }
        if (this.properties.getKeycloak().getRedirect() == null || this.properties.getKeycloak().getRedirect().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.redirect is  missing!");
        }
        if (this.properties.getKeycloak().getScope() == null || this.properties.getKeycloak().getScope().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.scope is  missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authentication.domain", this.properties.getDomain());
        map.put("authentication.session", this.properties.getSession());
        map.put("authentication.accessToken", this.properties.getAccessToken());
        map.put("authentication.redirect", this.properties.getRedirect());
        map.put("authentication.authorities-mapper", this.properties.getAuthoritiesMapper());
        map.put("authentication.keycloak.name", this.properties.getKeycloak().getName());
        map.put("authentication.keycloak.id", this.properties.getKeycloak().getId());
        map.put("authentication.keycloak.secret", this.properties.getKeycloak().getSecret());
        map.put("authentication.keycloak.issuer", this.properties.getKeycloak().getIssuer());
        map.put("authentication.keycloak.redirect", this.properties.getKeycloak().getRedirect());
        map.put("authentication.keycloak.scope", this.properties.getKeycloak().getScope());
        if (GlobalVars.date != null) {
            map.put("Date of deploy", GlobalVars.date.toString());
        }
        if (this.globalVars.getBuildDate() != null) {
            map.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            map.put("Version", this.globalVars.getVersion());
        }
        return map;
    }

    @Bean
    RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper());
        restTemplate.getMessageConverters().add(converter);
        return restTemplate;
    }

    @Bean
    public PropertyReader scopeReader() {
        return new PropertyReader(this.properties.getKeycloak().getScope());
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/**").allowedOriginPatterns(new String[]{"*" + AuthenticationConfiguration.this.properties.getDomain()}).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"}).allowCredentials(true);
            }
        };
    }
}

