/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security;

import com.google.gson.JsonParser;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.entities.User;
import eu.dnetlib.authentication.services.UserInfoService;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.session.FindByIndexNameSessionRepository;

@Configuration
public class OpenAIREAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger logger = LogManager.getLogger(OpenAIREAuthenticationSuccessHandler.class);
    private final Properties properties;
    private final UserInfoService service;

    @Autowired
    public OpenAIREAuthenticationSuccessHandler(Properties properties, UserInfoService service) {
        this.properties = properties;
        this.service = service;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        HttpSession session = request.getSession();
        String redirect = (String)session.getAttribute("redirect");
        User user = this.service.getUserInfo(request);
        session.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)user.getSub());
        try {
            if (this.properties.getAccessToken() != null && !this.properties.getAccessToken().isEmpty()) {
                Cookie accessToken = new Cookie(this.properties.getAccessToken(), user.getAccessToken());
                String regex = "^([A-Za-z0-9-_=]+)\\.([A-Za-z0-9-_=]+)\\.?([A-Za-z0-9-_.+=]*)$";
                Matcher matcher = Pattern.compile(regex).matcher(user.getAccessToken());
                if (matcher.find()) {
                    long exp = new JsonParser().parse(new String(Base64.getDecoder().decode(matcher.group(2)))).getAsJsonObject().get("exp").getAsLong();
                    accessToken.setMaxAge((int)(exp - new Date().getTime() / 1000L));
                } else {
                    accessToken.setMaxAge(3600);
                }
                accessToken.setPath("/");
                accessToken.setDomain(this.properties.getDomain());
                response.addCookie(accessToken);
            }
            if (redirect != null) {
                response.sendRedirect(redirect);
                session.removeAttribute("redirect");
            } else {
                response.sendRedirect(this.properties.getRedirect());
            }
        }
        catch (IOException e) {
            logger.error("IOException in redirection ", (Throwable)e);
            throw new IOException(e);
        }
    }
}

