/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security;

import eu.dnetlib.authentication.configuration.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@EnableRedisHttpSession
@Configuration
public class RedisConfig {
    private final Properties properties;
    private static final Logger logger = LogManager.getLogger(RedisConfig.class);

    @Autowired
    public RedisConfig(Properties properties) {
        this.properties = properties;
    }

    @Bean
    public JedisConnectionFactory connectionFactory() {
        logger.info(String.format("Redis connection listens to %s:%s ", this.properties.getRedis().getHost(), this.properties.getRedis().getPort()));
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration(this.properties.getRedis().getHost(), Integer.parseInt(this.properties.getRedis().getPort()));
        if (this.properties.getRedis().getPassword() != null) {
            configuration.setPassword(this.properties.getRedis().getPassword());
        }
        return new JedisConnectionFactory(configuration);
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.connectionFactory());
        return template;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(this.properties.getSession());
        serializer.setCookiePath("/");
        serializer.setDomainName(this.properties.getDomain());
        return serializer;
    }
}

