/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.services;

import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.entities.TokenResponse;
import eu.dnetlib.authentication.entities.User;
import eu.dnetlib.authentication.exception.ResourceNotFoundException;
import eu.dnetlib.authentication.services.SecurityService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UserInfoService {
    private static final Logger logger = LogManager.getLogger(UserInfoService.class);
    private final Properties properties;
    private final RestTemplate restTemplate;
    private final SecurityService service;
    private final OAuth2AuthorizedClientRepository repository;
    private final ClientRegistration client;

    @Autowired
    public UserInfoService(Properties properties, RestTemplate restTemplate, SecurityService service, OAuth2AuthorizedClientRepository repository, ClientRegistrationRepository clientRegistrationRepository) {
        this.properties = properties;
        this.restTemplate = restTemplate;
        this.service = service;
        this.repository = repository;
        this.client = clientRegistrationRepository.findByRegistrationId(properties.getKeycloak().getName());
    }

    private OAuth2AuthorizedClient getAuthorizedClient(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.repository.loadAuthorizedClient(this.properties.getKeycloak().getName(), authentication, request);
    }

    private String getAccessToken(OAuth2AuthorizedClient client) {
        if (client != null) {
            return client.getAccessToken().getTokenValue();
        }
        return null;
    }

    private String getRefreshToken(OAuth2AuthorizedClient client) {
        if (this.service.hasRefreshToken() && client != null) {
            return Objects.requireNonNull(client.getRefreshToken()).getTokenValue();
        }
        return null;
    }

    public User getUserInfo(HttpServletRequest request) throws ResourceNotFoundException {
        OAuth2AuthenticationToken authentication = this.service.getToken();
        if (authentication != null) {
            OAuth2AuthorizedClient client = this.getAuthorizedClient(request);
            return new User((DefaultOidcUser)authentication.getPrincipal(), authentication.getAuthorities(), this.getAccessToken(client), this.getRefreshToken(client));
        }
        throw new ResourceNotFoundException("No Session has been found");
    }

    public TokenResponse getAccessToken(String refreshToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity entity = new HttpEntity(this.getTokenRequest(refreshToken), (MultiValueMap)headers);
        return (TokenResponse)this.restTemplate.postForObject(this.client.getProviderDetails().getTokenUri(), (Object)entity, TokenResponse.class, new Object[0]);
    }

    public MultiValueMap<String, String> getTokenRequest(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.client.getClientId());
        map.add((Object)"client_secret", (Object)this.client.getClientSecret());
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"refresh_token", (Object)refreshToken);
        map.add((Object)"scope", (Object)"openid");
        return map;
    }

    public void revoke(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity entity = new HttpEntity(this.revokeTokenRequest(this.getRefreshToken(this.getAuthorizedClient(request))), (MultiValueMap)headers);
        try {
            this.restTemplate.exchange(this.client.getProviderDetails().getConfigurationMetadata().get("revocation_endpoint").toString(), HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Couldn't revoke refresh Tokens");
        }
    }

    public MultiValueMap<String, String> revokeTokenRequest(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.client.getClientId());
        map.add((Object)"client_secret", (Object)this.client.getClientSecret());
        map.add((Object)"token", (Object)refreshToken);
        return map;
    }

    public ClientRegistration getClient() {
        return this.client;
    }
}

