package eu.dnetlib.authentication.configuration;

import eu.dnetlib.authentication.utils.PropertyReader;
import eu.dnetlib.uoaauthorizationlibrary.AuthorizationConfiguration;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.HashMap;
import java.util.Map;

@Configuration
@EnableConfigurationProperties({Properties.class, GlobalVars.class})
@ComponentScan(basePackages = {"eu.dnetlib.authentication"})
@Import(AuthorizationConfiguration.class)
public class AuthenticationConfiguration {

    public static String LOGIN_URL = "/openid_connect_login";
    public static String LOGOUT_URL = "/openid_logout";
    private final Properties properties;
    private final GlobalVars globalVars;

    @Autowired
    public AuthenticationConfiguration(Properties properties, GlobalVars globalVars) {
        this.properties = properties;
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if(properties.getRedirect() == null || properties.getRedirect().isEmpty()) {
            throw new RuntimeException("authentication.redirect is  missing!");
        } else if(properties.getKeycloak().getName() == null || properties.getKeycloak().getName().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.name is  missing!");
        } else if(properties.getKeycloak().getId() == null || properties.getKeycloak().getId().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.id is  missing!");
        } else if(properties.getKeycloak().getSecret() == null || properties.getKeycloak().getSecret().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.secret is  missing!");
        } else if(properties.getKeycloak().getIssuer() == null || properties.getKeycloak().getIssuer().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.issuer is  missing!");
        } else if(properties.getKeycloak().getRedirect() == null || properties.getKeycloak().getRedirect().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.redirect is  missing!");
        } else if(properties.getKeycloak().getScope() == null || properties.getKeycloak().getScope().isEmpty()) {
            throw new RuntimeException("authentication.keycloak.scope is  missing!");
        }
    }

    public Map<String, String> getProperties() {
        Map<String, String> map = new HashMap<>();
        map.put("authentication.accessToken", properties.getAccessToken());
        map.put("authentication.redirect", properties.getRedirect());
        map.put("authentication.authorities-mapper", properties.getAuthoritiesMapper());
        map.put("authentication.keycloak.name", properties.getKeycloak().getName());
        map.put("authentication.keycloak.id", properties.getKeycloak().getId());
        map.put("authentication.keycloak.secret", properties.getKeycloak().getSecret());
        map.put("authentication.keycloak.issuer", properties.getKeycloak().getIssuer());
        map.put("authentication.keycloak.redirect", properties.getKeycloak().getRedirect());
        map.put("authentication.keycloak.scope", properties.getKeycloak().getScope());
        if(GlobalVars.date != null) {
            map.put("Date of deploy", GlobalVars.date.toString());
        }
        if(globalVars.getBuildDate() != null) {
            map.put("Date of build", globalVars.getBuildDate());
        }
        if (globalVars.getVersion() != null) {
            map.put("Version", globalVars.getVersion());
        }
        return map;
    }

    @Bean
    public PropertyReader scopeReader() {
        return new PropertyReader(this.properties.getKeycloak().getScope());
    }
}
