package eu.dnetlib.authentication.security;

import eu.dnetlib.authentication.configuration.AuthenticationConfiguration;
import eu.dnetlib.authentication.utils.Redirect;
import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;

public class OpenAIREAuthenticationFilter implements Filter {

    private final static Logger logger = LogManager.getLogger(OpenAIREAuthenticationFilter.class);
    private final String domain;

    public OpenAIREAuthenticationFilter(String domain) {
        super();
        this.domain = domain;
    }


    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest req) {
            final String originalUrl = req.getRequestURL().toString();
            if (originalUrl.contains(AuthenticationConfiguration.LOGIN_URL) || originalUrl.contains(AuthenticationConfiguration.LOGOUT_URL)) {
                Redirect.setRedirect(req, domain);
            }
        }
        chain.doFilter(request, response);
    }
}
