package eu.dnetlib.authentication.utils;


import eu.dnetlib.authentication.configuration.Properties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class Redirect {

    private final static Logger logger = LogManager.getLogger(Redirect.class);

    private static String getDomain(String url) throws MalformedURLException {
        return new URL(url).getHost();
    }

    public static void setRedirect(HttpServletRequest request, String domain) {
        HttpSession session = request.getSession();
        Enumeration<String> params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String param = params.nextElement();
            if(param.equalsIgnoreCase("redirect")) {
                String redirect = request.getParameter(param);
                try {
                    if(getDomain(redirect).endsWith(domain)) {
                        session.setAttribute("redirect", redirect);
                    }
                } catch (MalformedURLException e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }
}
