/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.security;

import eu.dnetlib.authentication.configuration.Keycloak;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.services.UserInfoService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class OpenAIRELogoutSuccessHandler
implements LogoutSuccessHandler {
    private final Keycloak keycloak;
    private final UserInfoService service;

    @Autowired
    public OpenAIRELogoutSuccessHandler(Properties properties, UserInfoService service) {
        this.keycloak = properties.getKeycloak();
        this.service = service;
    }

    private String encodeValue(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        response.sendRedirect(this.service.getClient().getProviderDetails().getConfigurationMetadata().get("end_session_endpoint") + "?client_id=" + this.keycloak.getId() + "&post_logout_redirect_uri=" + this.encodeValue(this.keycloak.getRedirect()));
    }
}

