/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.authentication.configuration;

import eu.dnetlib.authentication.configuration.GlobalVars;
import eu.dnetlib.authentication.configuration.Properties;
import eu.dnetlib.authentication.utils.PropertyReader;
import eu.dnetlib.uoaauthorizationlibrary.AuthorizationConfiguration;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={Properties.class, GlobalVars.class})
@ComponentScan(basePackages={"eu.dnetlib.authentication"})
@Import(value={AuthorizationConfiguration.class})
public class AuthenticationConfiguration {
    public static String LOGIN_URL = "/openid_connect_login";
    public static String LOGOUT_URL = "/openid_logout";
    private final Properties properties;
    private final GlobalVars globalVars;

    @Autowired
    public AuthenticationConfiguration(Properties properties, GlobalVars globalVars) {
        this.properties = properties;
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.properties.getRedirect() == null || this.properties.getRedirect().isEmpty()) {
            throw new RuntimeException("authentication.redirect is  missing!");
        }
        if (this.properties.getClient().getName() == null || this.properties.getClient().getName().isEmpty()) {
            throw new RuntimeException("authentication.auth.name is  missing!");
        }
        if (this.properties.getClient().getId() == null || this.properties.getClient().getId().isEmpty()) {
            throw new RuntimeException("authentication.auth.id is  missing!");
        }
        if (this.properties.getClient().getSecret() == null || this.properties.getClient().getSecret().isEmpty()) {
            throw new RuntimeException("authentication.auth.secret is  missing!");
        }
        if (this.properties.getClient().getIssuer() == null || this.properties.getClient().getIssuer().isEmpty()) {
            throw new RuntimeException("authentication.auth.issuer is  missing!");
        }
        if (this.properties.getClient().getRedirect() == null || this.properties.getClient().getRedirect().isEmpty()) {
            throw new RuntimeException("authentication.auth.redirect is  missing!");
        }
        if (this.properties.getClient().getScope() == null || this.properties.getClient().getScope().isEmpty()) {
            throw new RuntimeException("authentication.auth.scope is  missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("authentication.accessToken", this.properties.getAccessToken());
        map.put("authentication.redirect", this.properties.getRedirect());
        map.put("authentication.authorities-mapper", this.properties.getAuthoritiesMapper());
        map.put("authentication.auth.name", this.properties.getClient().getName());
        map.put("authentication.auth.id", this.properties.getClient().getId());
        map.put("authentication.auth.secret", this.properties.getClient().getSecret());
        map.put("authentication.auth.issuer", this.properties.getClient().getIssuer());
        map.put("authentication.auth.redirect", this.properties.getClient().getRedirect());
        map.put("authentication.auth.scope", this.properties.getClient().getScope());
        if (GlobalVars.date != null) {
            map.put("Date of deploy", GlobalVars.date.toString());
        }
        if (this.globalVars.getBuildDate() != null) {
            map.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            map.put("Version", this.globalVars.getVersion());
        }
        return map;
    }

    @Bean
    public PropertyReader scopeReader() {
        return new PropertyReader(this.properties.getClient().getScope());
    }
}

