/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoamonitorservice.configuration.GlobalVars;
import eu.dnetlib.uoamonitorservice.configuration.properties.MongoConfig;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorDeployService {
    private final MongoConfig mongoConfig;
    private final GlobalVars globalVars;

    @Autowired
    public MonitorDeployService(MongoConfig mongoConfig, GlobalVars globalVars) {
        this.mongoConfig = mongoConfig;
        this.globalVars = globalVars;
    }

    @PostConstruct
    public void checkProperties() {
        if (this.mongoConfig.getHost() == null || this.mongoConfig.getHost().isEmpty()) {
            throw new RuntimeException("monitor-service.mongodb.host is missing!");
        }
        if (this.mongoConfig.getDatabase() == null || this.mongoConfig.getDatabase().isEmpty()) {
            throw new RuntimeException("monitor-service.mongodb.database is missing!");
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("monitor-service.mongodb.database", this.mongoConfig.getDatabase());
        response.put("monitor-service.mongodb.host", this.mongoConfig.getHost());
        response.put("monitor-service.mongodb.port", "" + this.mongoConfig.getPort());
        response.put("monitor-service.mongodb.username", this.mongoConfig.getUsername() == null ? null : "[unexposed value]");
        response.put("monitor-service.mongodb.password", this.mongoConfig.getPassword() == null ? null : "[unexposed value]");
        response.put("Date of deploy", GlobalVars.date.toString());
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        if (this.globalVars.getVersion() != null) {
            response.put("Version", this.globalVars.getVersion());
        }
        return response;
    }
}

