/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.generics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.dnetlib.uoamonitorservice.annotations.Children;
import eu.dnetlib.uoamonitorservice.annotations.Overridable;
import eu.dnetlib.uoamonitorservice.annotations.Unmodifiable;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.primitives.Locale;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import eu.dnetlib.uoamonitorservice.primitives.Umbrella;
import eu.dnetlib.uoamonitorservice.utils.EnumUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Transient;

public class StakeholderGeneric<T, S>
extends Common {
    @Unmodifiable
    protected String defaultId;
    protected StakeholderType type;
    protected Date projectUpdateDate = null;
    protected String index_id;
    protected String index_name;
    protected String index_shortName;
    protected String statsProfile = "monitor";
    protected String logoUrl;
    protected boolean isUpload = false;
    protected Locale locale = Locale.EU;
    protected String funderType;
    @Unmodifiable
    protected Boolean standalone = true;
    @Children
    @Unmodifiable
    @Overridable(restorable=false)
    protected List<T> topics = new ArrayList<T>();
    @Unmodifiable
    protected Umbrella<S> umbrella;
    @Unmodifiable
    protected Map<String, Map<String, Object>> overrides;
    @Transient
    public List<Stakeholder> otherParents;
    @Transient
    public Stakeholder parent;

    public StakeholderGeneric() {
    }

    public StakeholderGeneric(StakeholderGeneric<?, ?> stakeholder) {
        super(stakeholder);
        this.defaultId = stakeholder.getDefaultId();
        this.setType(stakeholder.getType());
        this.projectUpdateDate = stakeholder.getProjectUpdateDate();
        this.index_id = stakeholder.getIndex_id();
        this.index_name = stakeholder.getIndex_name();
        this.index_shortName = stakeholder.getIndex_shortName();
        this.statsProfile = stakeholder.getStatsProfile();
        this.logoUrl = stakeholder.getLogoUrl();
        this.isUpload = stakeholder.getIsUpload();
        this.setLocale(stakeholder.getLocale());
        this.funderType = stakeholder.getFunderType();
        this.overrides = stakeholder.getOverrides() != null ? stakeholder.getOverrides() : new HashMap<String, Map<String, Object>>();
        this.standalone = stakeholder.isStandalone();
        this.topics = new ArrayList<T>();
        this.umbrella = null;
        this.parent = stakeholder.getParent();
        this.otherParents = stakeholder.getOtherParents();
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public String getType() {
        return EnumUtils.toLabel(this.type);
    }

    public void setType(String type) {
        this.type = StakeholderType.fromLabel(type);
    }

    public Date getProjectUpdateDate() {
        return this.projectUpdateDate;
    }

    public void setProjectUpdateDate(Date projectUpdateDate) {
        this.projectUpdateDate = projectUpdateDate;
    }

    public String getIndex_id() {
        return this.index_id;
    }

    public void setIndex_id(String index_id) {
        this.index_id = index_id;
    }

    public String getIndex_name() {
        return this.index_name;
    }

    public void setIndex_name(String index_name) {
        this.index_name = index_name;
    }

    public String getIndex_shortName() {
        return this.index_shortName;
    }

    public void setIndex_shortName(String index_shortName) {
        this.index_shortName = index_shortName;
    }

    public String getStatsProfile() {
        return this.statsProfile;
    }

    public void setStatsProfile(String statsProfile) {
        this.statsProfile = statsProfile;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public boolean getIsUpload() {
        return this.isUpload;
    }

    public void setIsUpload(boolean isUpload) {
        this.isUpload = isUpload;
    }

    public String getLocale() {
        return EnumUtils.toLabel(this.locale);
    }

    public void setLocale(String locale) {
        this.locale = Locale.fromLabel(locale);
    }

    public String getFunderType() {
        return this.funderType;
    }

    public void setFunderType(String funderType) {
        this.funderType = funderType;
    }

    public boolean isStandalone() {
        if (this.standalone == null) {
            this.standalone = true;
        }
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isReference() {
        return !this.isDefault() && !this.defaultId.equals("-1");
    }

    public boolean isDefault() {
        return this.defaultId == null;
    }

    public List<T> getTopics() {
        return this.topics;
    }

    public void setTopics(List<T> topics) {
        this.topics = topics;
    }

    @JsonIgnore
    public Map<String, Map<String, Object>> getOverrides() {
        if (this.overrides == null) {
            return Collections.emptyMap();
        }
        return this.overrides;
    }

    public void setOverrides(Map<String, Map<String, Object>> overrides) {
        this.overrides = overrides;
    }

    public Umbrella<S> getUmbrella() {
        return this.umbrella;
    }

    @JsonIgnore
    public Optional<Umbrella<S>> getUmbrellaOptional() {
        return Optional.ofNullable(this.umbrella);
    }

    public void setUmbrella(Umbrella<S> umbrella) {
        this.umbrella = umbrella;
    }

    public Map<String, Object> getOverride(String id) {
        if (this.overrides == null) {
            this.overrides = new HashMap<String, Map<String, Object>>();
        }
        return this.overrides.getOrDefault(id, new HashMap());
    }

    public <Entity extends Common> void setOverride(String id, Map<String, Object> override, Class<Entity> clazz) {
        if (this.defaultId != null) {
            if (this.overrides == null) {
                this.overrides = new HashMap<String, Map<String, Object>>();
            }
            if (override != null && !override.isEmpty()) {
                override.put("className", clazz.getName());
                this.overrides.put(id, override);
            } else {
                this.overrides.remove(id);
            }
        }
    }

    public <V> void setOverride(String id, String field, V value) {
        if (this.defaultId != null) {
            Map<String, Object> override = this.getOverride(id);
            override.put(field, value);
            this.overrides.put(id, override);
        }
    }

    public List<Stakeholder> getOtherParents() {
        return this.otherParents;
    }

    public void setOtherParents(List<Stakeholder> otherParents) {
        this.otherParents = otherParents;
    }

    public Stakeholder getParent() {
        return this.parent;
    }

    public void setParent(Stakeholder parent) {
        this.parent = parent;
    }

    public <Entity> List<String> getEntitiesFromOverrides(Class<Entity> clazz) {
        if (this.overrides != null) {
            return this.overrides.entrySet().stream().filter(e -> clazz.getName().equals(((Map)e.getValue()).get("className"))).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

