/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.entities.Portal;
import eu.dnetlib.uoaadmintoolslibrary.entities.fullEntities.PortalResponse;
import eu.dnetlib.uoaadmintoolslibrary.services.PortalService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor", "/funder", "/project", "/ri", "/organization", "country", "researcher", "datasource", "publisher", "journal"})
public class MonitorController {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final PortalService portalService;

    @Autowired
    public MonitorController(PortalService portalService) {
        this.portalService = portalService;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> updatePortal(@RequestBody Portal portal) {
        return ResponseEntity.ok((Object)this.portalService.updatePortal(portal));
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<PortalResponse> insertPortal(@RequestBody Portal portal) {
        return ResponseEntity.ok((Object)this.portalService.insertPortal(portal));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> deletePortals(@RequestBody List<String> portals) {
        portals.forEach(arg_0 -> ((PortalService)this.portalService).deletePortal(arg_0));
        return ResponseEntity.ok((Object)true);
    }
}

