/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.service;

import eu.dnetlib.uoaauthorizationlibrary.authorization.exceptions.http.NotFoundException;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.common.CommonService;
import eu.dnetlib.uoamonitorservice.common.Void;
import eu.dnetlib.uoamonitorservice.dao.StakeholderRepository;
import eu.dnetlib.uoamonitorservice.dto.BuildStakeholder;
import eu.dnetlib.uoamonitorservice.dto.ManageStakeholders;
import eu.dnetlib.uoamonitorservice.dto.StakeholderFull;
import eu.dnetlib.uoamonitorservice.dto.StakeholderOptions;
import eu.dnetlib.uoamonitorservice.dto.UpdateUmbrella;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.handlers.BadRequestException;
import eu.dnetlib.uoamonitorservice.primitives.Action;
import eu.dnetlib.uoamonitorservice.primitives.StakeholderType;
import eu.dnetlib.uoamonitorservice.primitives.Umbrella;
import eu.dnetlib.uoamonitorservice.primitives.Visibility;
import eu.dnetlib.uoamonitorservice.service.TopicService;
import eu.dnetlib.uoamonitorservice.utils.GenericAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StakeholderService
extends CommonService<Stakeholder, StakeholderFull, Void> {
    StakeholderRepository repository;

    @Autowired
    protected StakeholderService(AuthorizationService authorizationService, StakeholderRepository repository, TopicService topicService) {
        super(authorizationService, repository);
        this.repository = repository;
        this.childService = topicService;
    }

    public Stakeholder findByAlias(String alias) {
        return this.repository.findByAlias(alias);
    }

    public Stakeholder findByPath(String id) {
        Stakeholder stakeholder = (Stakeholder)this.find(id);
        return (Stakeholder)super.findByPath(stakeholder, Void.getInstance(), id);
    }

    public Stakeholder secure(Stakeholder stakeholder) {
        return super.secure(stakeholder, stakeholder);
    }

    public List<Stakeholder> getAll(String type) {
        return this.repository.allStakeholders(type);
    }

    public List<String> getAllAliases(String type) {
        return this.getAll(type).stream().map(Common::getAlias).collect(Collectors.toList());
    }

    public List<Stakeholder> getAccessedStakeholders(List<Stakeholder> stakeholders) {
        return stakeholders.stream().filter(x$0 -> this.hasAccessAuthority((Stakeholder)x$0)).collect(Collectors.toList());
    }

    public ManageStakeholders getManageStakeholders() {
        return this.getManageStakeholders(null);
    }

    public ManageStakeholders getManageStakeholders(String type) {
        ManageStakeholders manageStakeholders = new ManageStakeholders();
        manageStakeholders.setTemplates(this.getAccessedStakeholders(this.repository.defaultStakeholders(type)));
        manageStakeholders.setStandalone(this.getAccessedStakeholders(this.repository.standaloneStakeholders(type)));
        manageStakeholders.setDependent(this.getAccessedStakeholders(this.repository.dependentStakeholders(type)));
        manageStakeholders.setUmbrella(this.getAccessedStakeholders(this.repository.umbrellaStakeholders(type)));
        return manageStakeholders;
    }

    public List<Stakeholder> getVisibleStakeholders(String type, String defaultId) {
        return this.repository.browseStakeholders(type, defaultId).stream().filter(stakeholder -> stakeholder.getVisibility().equals(Visibility.PUBLIC.getLabel()) || stakeholder.getVisibility().equals(Visibility.RESTRICTED.getLabel()) || this.hasAccessAuthority((Stakeholder)stakeholder)).collect(Collectors.toList());
    }

    @Override
    public Stakeholder save(Stakeholder stakeholder) {
        return super.save(stakeholder.validate());
    }

    @Override
    public StakeholderFull getFull(Stakeholder stakeholder, boolean umbrella) {
        StakeholderFull full = (StakeholderFull)super.getFull(stakeholder, stakeholder.getId());
        if (full == null) {
            this.unauthorized("Get stakeholder: You are not authorized to access stakeholder with alias: " + stakeholder.getAlias());
        } else {
            full.setParent(stakeholder.getParent());
            full.setOtherParents(stakeholder.getOtherParents());
            if (umbrella) {
                full.setUmbrella(Umbrella.convert(stakeholder.getUmbrella(), this));
            }
        }
        return full;
    }

    public StakeholderFull getFull(Stakeholder stakeholder) {
        return this.getFull(stakeholder, true);
    }

    public StakeholderFull getFullWithParents(Stakeholder stakeholder, String type, String parent) {
        stakeholder.setParent(this.repository.getActiveParent(parent, StakeholderType.fromLabel(type), stakeholder.getId()));
        stakeholder.setOtherParents(this.repository.getOtherParents(parent, StakeholderType.fromLabel(type), stakeholder.getId()));
        return this.getFull(stakeholder, false);
    }

    public Stakeholder generateAlias(Stakeholder stakeholder) {
        return this.generateAlias(stakeholder, null);
    }

    public Stakeholder generateAlias(Stakeholder stakeholder, String field) {
        Object alias = stakeholder.getAlias();
        if (field != null) {
            try {
                alias = Objects.requireNonNull(GenericAccessor.getField(stakeholder, field)).toString().toLowerCase();
                alias = Objects.requireNonNull(alias).replaceAll("[^a-z0-9-]", "-");
                alias = ((String)Objects.requireNonNull(alias)).replaceAll("-+", "-");
                alias = ((String)Objects.requireNonNull(alias)).replaceAll("^-+|-+$", "-");
            }
            catch (NullPointerException e) {
                throw new BadRequestException("Cannot generate alias with field " + field + " for stakeholder: " + stakeholder.getName());
            }
        }
        if (alias == null) {
            throw new BadRequestException("Cannot generate alias for stakeholder: " + stakeholder.getName());
        }
        int duplicates = 1;
        while (this.repository.findByAlias((String)alias, false) != null) {
            alias = (String)alias + duplicates;
            ++duplicates;
        }
        stakeholder.setAlias((String)alias);
        return stakeholder;
    }

    public List<Stakeholder> buildStakeholders(BuildStakeholder buildStakeholder) {
        List<Stakeholder> stakeholders = new ArrayList<Stakeholder>();
        if (buildStakeholder.isMultiBuild()) {
            stakeholders = buildStakeholder.getIndexFields().stream().map(fields -> {
                Stakeholder stakeholder = new Stakeholder(buildStakeholder.getStakeholder());
                stakeholder.setIndex_id((String)fields.get(stakeholder.getIndex_id()));
                stakeholder.setIndex_name((String)fields.get(stakeholder.getIndex_name()));
                stakeholder.setIndex_shortName((String)fields.get(stakeholder.getIndex_shortName()));
                stakeholder.setName(stakeholder.getIndex_name());
                stakeholder = this.generateAlias(stakeholder, stakeholder.getAlias());
                return stakeholder;
            }).toList();
        } else {
            stakeholders.add(buildStakeholder.getStakeholder());
        }
        List<Stakeholder> saved = stakeholders.stream().map(stakeholder -> this.buildStakeholder(this.setStakeholderOptions((Stakeholder)stakeholder, buildStakeholder), buildStakeholder.getCopyId())).toList();
        if (buildStakeholder.getParent() != null && !buildStakeholder.isUmbrella().booleanValue()) {
            Stakeholder umbrellaStakeholder = this.findByPath(buildStakeholder.getParent());
            this.updateUmbrella(umbrellaStakeholder, new UpdateUmbrella(buildStakeholder.getStakeholder().getType(), Action.ADD, null));
            saved.forEach(stakeholder -> this.updateUmbrella(umbrellaStakeholder, new UpdateUmbrella(stakeholder.getType(), Action.ADD, stakeholder.getId())));
        }
        return saved;
    }

    public Stakeholder buildStakeholder(Stakeholder stakeholder, String copyId) {
        if (stakeholder.getDefaultId() == null) {
            stakeholder.setTopics(new ArrayList());
            if (copyId != null) {
                Stakeholder copyFrom = this.findByPath(copyId);
                stakeholder = this.save(stakeholder);
                String stakeholderId = stakeholder.getId();
                stakeholder.setTopics(copyFrom.getTopics().stream().map(id -> this.childService.copy(stakeholderId, (String)id)).collect(Collectors.toList()));
            }
        } else {
            stakeholder = this.generateAlias(stakeholder);
            stakeholder.setTopics(new ArrayList());
        }
        return this.save(stakeholder);
    }

    public Stakeholder setStakeholderOptions(Stakeholder stakeholder, StakeholderOptions options) {
        if (options.isStandalone() != null) {
            stakeholder.setStandalone(options.isStandalone());
        }
        if (options.isUmbrella() != null) {
            if (stakeholder.getId() != null) {
                if (stakeholder.getUmbrellaOptional().isEmpty() && options.isUmbrella().booleanValue()) {
                    stakeholder.setUmbrella(new Umbrella());
                } else if (stakeholder.getUmbrellaOptional().isPresent() && !options.isUmbrella().booleanValue()) {
                    stakeholder.setUmbrella(null);
                }
            } else if (options.isUmbrella().booleanValue()) {
                stakeholder.setUmbrella(new Umbrella());
            }
        }
        return stakeholder;
    }

    public String delete(String id) {
        Stakeholder stakeholder = this.findByPath(id);
        if (this.hasDeleteAuthority(stakeholder)) {
            this.repository.umbrellaStakeholders(null).forEach(umbrella -> {
                List ids = umbrella.getUmbrella().getChildren().get(stakeholder.getType());
                if (ids != null && ids.contains(stakeholder.getId())) {
                    this.removeChild(umbrella.getId(), stakeholder.getType(), stakeholder.getId());
                }
            });
            this.repository.findByDefaultId(stakeholder.getId()).forEach(child -> this.delete(child.getId()));
            super.delete(stakeholder, stakeholder);
            return stakeholder.getAlias();
        }
        this.unauthorized("Delete " + this.entityClass.getName() + " You are not authorized to delete " + this.entityClass.getName() + " with id: " + stakeholder.getId());
        return null;
    }

    public StakeholderFull changeVisibility(Stakeholder stakeholder, String visibility, Boolean propagate) {
        return (StakeholderFull)super.changeVisibility(stakeholder, stakeholder, visibility, propagate);
    }

    public Umbrella<Stakeholder> updateUmbrella(Stakeholder stakeholder, UpdateUmbrella update) {
        if (this.hasEditAuthority(stakeholder)) {
            if (update.getAction().equals(Action.ADD.getLabel())) {
                if (update.getChild() != null) {
                    return this.addChild(stakeholder.getId(), update.getType(), update.getChild());
                }
                return this.addType(stakeholder.getId(), update.getType());
            }
            if (update.getAction().equals(Action.REMOVE.getLabel())) {
                if (update.getChild() != null) {
                    return this.removeChild(stakeholder.getId(), update.getType(), update.getChild());
                }
                return this.removeType(stakeholder.getId(), update.getType());
            }
            if (update.getAction().equals(Action.UPDATE.getLabel())) {
                if (update.getType() != null) {
                    return this.updateChildren(stakeholder.getId(), update.getType(), update.getChildren());
                }
                return this.updateTypes(stakeholder.getId(), update.getTypes());
            }
        } else {
            this.unauthorized("You are not authorized to update umbrella in stakeholder with id: " + stakeholder.getId());
        }
        return null;
    }

    public Umbrella<Stakeholder> addType(String id, String type) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (umbrella.addType(type)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFull(this.save(stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot add type: " + type + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> removeType(String id, String type) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (umbrella.removeType(type)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFull(this.save(stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot remove type: " + type + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> addChild(String id, String type, String childId) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        Stakeholder child = this.findByPath(childId);
        if (child.getType().equals(type) && umbrella.addChild(type, childId)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFull(this.save(stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot add child: " + childId + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> removeChild(String id, String type, String childId) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        Stakeholder child = this.findByPath(childId);
        if (child.getType().equals(type) && umbrella.removeChild(type, childId)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFull(this.save(stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot remove child: " + childId + " to stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> updateTypes(String id, List<String> types) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (stakeholder.getUmbrella().update(types)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFull(this.save(stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot update types in umbrella of stakeholder with id " + id);
    }

    public Umbrella<Stakeholder> updateChildren(String id, String type, List<String> children) {
        Stakeholder stakeholder = this.findByPath(id);
        Umbrella umbrella = stakeholder.getUmbrellaOptional().orElseThrow(() -> new NotFoundException("Umbrella not found in the stakeholder with id " + id));
        if (stakeholder.getUmbrella().update(type, children)) {
            stakeholder.setUmbrella(umbrella);
            return this.getFull(this.save(stakeholder)).getUmbrella();
        }
        throw new BadRequestException("Cannot update children of " + type + " in umbrella of stakeholder with id " + id);
    }
}

