/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.blackboard.ActionStatus;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardMessage;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Element;

public class BlackboardHandlerImpl
implements BlackboardServerHandler {
    private JaxbFactory<BlackboardMessage> messageFactory;
    private UniqueServiceLocator serviceLocator;

    @Override
    public BlackboardJob getJob(OpaqueResource profile) {
        XPath xpa = XPathFactory.newInstance().newXPath();
        try {
            Element source = (Element)xpa.evaluate("/RESOURCE_PROFILE/BODY/BLACKBOARD/MESSAGE[@id = /RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_REQUEST]", profile.asDom(), XPathConstants.NODE);
            if (source == null) {
                throw new IllegalStateException("cannot find last blackboard message in the service profile");
            }
            return new BlackboardJobImpl(profile.getResourceId(), (BlackboardMessage)this.messageFactory.parse((Source)new DOMSource(source)));
        }
        catch (JAXBException e) {
            throw new IllegalStateException("cannot parse blackboard message", e);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("cannot find last blackboard message in the service profile", e);
        }
    }

    @Override
    public void done(BlackboardJob job) {
        job.setActionStatus(ActionStatus.DONE);
        this.replyJob(job);
    }

    @Override
    public void failed(BlackboardJob job, Throwable exception) {
        job.setActionStatus(ActionStatus.FAILED);
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        job.getParameters().put("error", exception.toString());
        job.getParameters().put("errorDetails", stackTrace.toString());
        this.replyJob(job);
    }

    @Override
    public void ongoing(BlackboardJob job) {
        job.setActionStatus(ActionStatus.ONGOING);
        this.replyJob(job);
    }

    protected void replyJob(BlackboardJob job) {
        try {
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).replyBlackBoardMessage(job.getServiceId(), this.messageFactory.serialize((Object)job.getMessage()));
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot reply the blackboard message", e);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("cannot serialize blackboard message", e);
        }
    }

    public JaxbFactory<BlackboardMessage> getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(JaxbFactory<BlackboardMessage> messageFactory) {
        this.messageFactory = messageFactory;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

