/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.cql.mongo;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import eu.dnetlib.functionality.cql.parse.Relation;
import eu.dnetlib.functionality.cql.parse.Relations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLTermNode;

public class MongoCqlTranslator {
    private static final Log log = LogFactory.getLog(MongoCqlTranslator.class);
    private final List<String> dateFields = Lists.newArrayList((Object[])new String[]{"datestamp", "lastCollectionDate"});

    public static Bson toMongo(String query) throws CQLParseException, IOException {
        log.debug((Object)("PARSING: " + query));
        if (StringUtils.isBlank((CharSequence)query)) {
            return new BasicDBObject();
        }
        Bson parsed = new MongoCqlTranslator().doParse(query);
        log.debug((Object)parsed);
        return parsed;
    }

    private Bson doParse(String query) throws IOException, CQLParseException {
        CQLParser parser = new CQLParser();
        CQLNode root = parser.parse(query);
        return this.doParse(root);
    }

    private Bson doParse(CQLNode node) throws CQLParseException {
        if (node instanceof CQLTermNode) {
            return this.doTranslate((CQLTermNode)node);
        }
        if (node instanceof CQLBooleanNode) {
            return this.doTranslate((CQLBooleanNode)node);
        }
        throw new RuntimeException("error choice for CQLNode " + node.getClass());
    }

    private Bson doTranslate(CQLTermNode termNode) throws CQLParseException {
        if (termNode.getTerm().equals("*")) {
            return new BasicDBObject();
        }
        String relation = termNode.getRelation().getBase();
        Relation rel = Relations.get(relation);
        return this.handleRelationNode(rel, termNode);
    }

    private Bson handleRelationNode(Relation rel, CQLTermNode termNode) throws CQLParseException {
        BasicDBObject mongoQueryObject = new BasicDBObject();
        String term = termNode.getTerm();
        String indexName = termNode.getIndex();
        String termObj = term;
        if (this.dateFields.contains(indexName)) {
            OAIDate termDate = this.parseDate(term);
            return this.handleDateRelationNode(indexName, rel, termDate);
        }
        if (indexName.equals("_id")) {
            termObj = new ObjectId(term);
        }
        switch (rel) {
            case EQUAL: 
            case EXACT: {
                mongoQueryObject.put((Object)indexName, (Object)termObj);
                break;
            }
            case NOT: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$ne", (Object)termObj));
                break;
            }
            case GT: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$gt", (Object)termObj));
                break;
            }
            case GTE: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$gte", (Object)termObj));
                break;
            }
            case LT: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$lt", (Object)termObj));
                break;
            }
            case LTE: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$lte", (Object)termObj));
                break;
            }
            default: {
                throw new CQLParseException("Can't parse query: relation " + (Object)((Object)rel) + " not supported!");
            }
        }
        return mongoQueryObject;
    }

    private Bson doTranslate(CQLBooleanNode node) throws CQLParseException {
        if (node instanceof CQLAndNode) {
            return this.getBooleanQuery("$and", node);
        }
        if (node instanceof CQLOrNode) {
            return this.getBooleanQuery("$or", node);
        }
        if (node instanceof CQLNotNode) {
            return this.getNotQuery((CQLNotNode)node);
        }
        throw new RuntimeException("error choice for CQLBooleanNode " + node.getClass());
    }

    private Bson getBooleanQuery(String mongoOperator, CQLBooleanNode node) throws CQLParseException {
        Bson left = this.doParse(node.left);
        Bson right = this.doParse(node.right);
        BasicDBObject opQuery = new BasicDBObject();
        ArrayList termList = Lists.newArrayList((Object[])new Bson[]{left, right});
        opQuery.put((Object)mongoOperator, (Object)termList);
        return opQuery;
    }

    private Bson getNotQuery(CQLNotNode node) throws CQLParseException {
        Bson left = this.doParse(node.left);
        Bson right = this.doParse(node.right);
        BasicDBObject notRight = new BasicDBObject("$not", (Object)right);
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList termList = Lists.newArrayList((Object[])new Bson[]{left, notRight});
        andQuery.put((Object)"$and", (Object)termList);
        return andQuery;
    }

    private Bson handleDateRelationNode(String indexName, Relation rel, OAIDate date) {
        BasicDBObject mongoQueryObject = new BasicDBObject();
        DateTime fromDate = date.date;
        switch (rel) {
            case EQUAL: 
            case EXACT: {
                if (date.onlyDate) {
                    DateTime endDate = date.date.plusDays(1);
                    mongoQueryObject.put((Object)indexName, (Object)BasicDBObjectBuilder.start((String)"$gte", (Object)fromDate.toDate()).append("$lt", (Object)endDate.toDate()).get());
                    break;
                }
                DateTime endDate = date.date.plusSeconds(1);
                mongoQueryObject.put((Object)indexName, (Object)BasicDBObjectBuilder.start((String)"$gte", (Object)fromDate.toDate()).append("$lt", (Object)endDate.toDate()).get());
                break;
            }
            case NOT: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$ne", (Object)fromDate.toDate()));
                break;
            }
            case GT: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$gt", (Object)fromDate.toDate()));
                break;
            }
            case GTE: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$gte", (Object)fromDate.toDate()));
                break;
            }
            case LT: {
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$lt", (Object)fromDate.toDate()));
                break;
            }
            case LTE: {
                if (date.onlyDate) {
                    fromDate = date.date.plusDays(1);
                    mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$lt", (Object)fromDate.toDate()));
                    break;
                }
                mongoQueryObject.put((Object)indexName, (Object)new BasicDBObject("$lte", (Object)fromDate.toDate()));
                break;
            }
            default: {
                throw new RuntimeException("Can't parse query: relation " + (Object)((Object)rel) + " not supported!");
            }
        }
        return mongoQueryObject;
    }

    private OAIDate parseDate(String date) {
        DateTimeFormatter dateNoTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
        DateTimeFormatter iso8601NoMsTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withZoneUTC();
        DateTimeFormatter iso8601Formatter = ISODateTimeFormat.dateTime().withZoneUTC();
        OAIDate res = null;
        try {
            log.debug((Object)("Using default " + iso8601Formatter.getClass()));
            DateTime dt = iso8601Formatter.parseDateTime(date);
            res = new OAIDate(dt, false);
        }
        catch (Exception e) {
            try {
                log.debug((Object)"Switching to ISO with no millisecond date formatter: yyyy-MM-dd'T'HH:mm:ssZ");
                DateTime dt = iso8601NoMsTimeFormatter.parseDateTime(date);
                res = new OAIDate(dt, false);
            }
            catch (Exception ex) {
                log.debug((Object)"Switching to simple date formatter: yyyy-MM-dd");
                DateTime dt = dateNoTimeFormatter.parseDateTime(date);
                res = new OAIDate(dt, true);
            }
        }
        return res;
    }

    class OAIDate {
        DateTime date;
        boolean onlyDate;

        OAIDate(DateTime date, boolean onlyDate) {
            this.date = date;
            this.onlyDate = onlyDate;
        }
    }
}

