/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.cql;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.functionality.cql.CQLExpander;
import eu.dnetlib.functionality.cql.CQLFieldLister;
import eu.dnetlib.functionality.cql.CqlFilter;
import eu.dnetlib.functionality.cql.CqlGroup;
import eu.dnetlib.functionality.cql.CqlTermLister;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.ModifierSet;

public class CqlUtils {
    public static final String cqlDefaultField = "cql.serverChoice";

    private CqlUtils() {
    }

    public static CQLNode expand(String query, Set<String> fields) {
        return CqlUtils.expand(CqlUtils.parse(query), fields);
    }

    public static CQLNode expand(CQLNode root, Set<String> fields) {
        if (fields.isEmpty()) {
            return root;
        }
        Map<String, CQLNode> unfielded = CqlUtils.group(CqlUtils.filter(root, CqlUtils.listFields(root)), (List<String>)Lists.newArrayList((Object[])new String[]{cqlDefaultField}));
        CQLNode terms = unfielded.get("cql.filtered");
        if (terms != null) {
            CQLNode expand = new CQLExpander().expand(terms, fields);
            return new CQLOrNode(root, expand, new ModifierSet("or"));
        }
        return root;
    }

    public static List<String> listFields(String query) {
        return CqlUtils.listFields(CqlUtils.parse(query));
    }

    public static List<String> listFields(CQLNode root) {
        Set<String> fields = new CQLFieldLister().listFields(root);
        fields.remove(cqlDefaultField);
        return Lists.newArrayList(fields);
    }

    public static List<String> listTerms(String query, String field) {
        return CqlUtils.listTerms(CqlUtils.parse(query), field);
    }

    public static List<String> listTerms(CQLNode query, String field) {
        return new CqlTermLister().listTerms(CqlUtils.group(query, (List<String>)Lists.newArrayList((Object[])new String[]{field})).get(field), field);
    }

    public static Map<String, CQLNode> group(CQLNode root, List<String> fields) {
        Map<String, CQLNode> groups = new CqlGroup().group(root, fields);
        groups.put("cql.filtered", new CqlFilter().filter(root, fields));
        return Maps.filterValues(groups, (Predicate)Predicates.notNull());
    }

    public static Map<String, CQLNode> group(String query, List<String> fields) {
        return CqlUtils.group(CqlUtils.parse(query), fields);
    }

    public static CQLNode filter(CQLNode query, List<String> fields) {
        return new CqlFilter().filter(query, fields);
    }

    public static CQLNode filter(String query, List<String> fields) {
        return CqlUtils.filter(CqlUtils.parse(query), fields);
    }

    public static CQLNode parse(String query) {
        try {
            return query != null ? new CQLParser().parse(query) : null;
        }
        catch (CQLParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

