/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.cql.lucene;

import com.google.common.collect.BiMap;
import eu.dnetlib.functionality.cql.CqlValueTransformerMap;
import eu.dnetlib.functionality.cql.lucene.QueryOptions;
import eu.dnetlib.functionality.cql.lucene.SortOperation;
import eu.dnetlib.functionality.cql.lucene.TranslatedQuery;
import eu.dnetlib.functionality.cql.parse.AndNode;
import eu.dnetlib.functionality.cql.parse.Node;
import eu.dnetlib.functionality.cql.parse.NotNode;
import eu.dnetlib.functionality.cql.parse.OrNode;
import eu.dnetlib.functionality.cql.parse.Relations;
import eu.dnetlib.functionality.cql.parse.TermNode;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLSortNode;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.ModifierSet;

public class LuceneCqlTranslator {
    public static TranslatedQuery translate(CQLNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException {
        if (node instanceof CQLBooleanNode) {
            return LuceneCqlTranslator.doTranslate((CQLBooleanNode)node, valueTranformerMap, cqlOptions, aliases, weights);
        }
        if (node instanceof CQLTermNode) {
            return LuceneCqlTranslator.doTranslate((CQLTermNode)node, valueTranformerMap, cqlOptions, aliases, weights);
        }
        if (node instanceof CQLSortNode) {
            return LuceneCqlTranslator.doTranslate((CQLSortNode)node, valueTranformerMap, cqlOptions, aliases, weights);
        }
        throw new RuntimeException("error choice");
    }

    private static TranslatedQuery doTranslate(CQLSortNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException {
        TranslatedQuery subQuery = LuceneCqlTranslator.translate(node.subtree, valueTranformerMap, cqlOptions, aliases, weights);
        Node query = subQuery.getQuery();
        String sortField = ((ModifierSet)node.getSortIndexes().get(0)).getBase();
        SortOperation.Mode sortMode = SortOperation.modifiersToMode(((ModifierSet)node.getSortIndexes().get(0)).getModifiers());
        QueryOptions options = new QueryOptions(new SortOperation(sortField, sortMode));
        return new TranslatedQuery(query, options);
    }

    private static TranslatedQuery doTranslate(CQLBooleanNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException {
        TranslatedQuery left = LuceneCqlTranslator.translate(node.left, valueTranformerMap, cqlOptions, aliases, weights);
        TranslatedQuery right = LuceneCqlTranslator.translate(node.right, valueTranformerMap, cqlOptions, aliases, weights);
        QueryOptions options = right.getOptions();
        if (options != null) {
            options.merge(left.getOptions());
        }
        if (node instanceof CQLAndNode) {
            return new TranslatedQuery(new AndNode(left.getQuery(), right.getQuery()), options);
        }
        if (node instanceof CQLOrNode) {
            return new TranslatedQuery(new OrNode(left.getQuery(), right.getQuery()), options);
        }
        if (node instanceof CQLNotNode) {
            return new TranslatedQuery(new NotNode(left.getQuery(), right.getQuery()), options);
        }
        throw new RuntimeException("unknow boolean node");
    }

    private static TranslatedQuery doTranslate(CQLTermNode node, CqlValueTransformerMap valueTranformerMap, Map<String, List<String>> cqlOptions, BiMap<String, String> aliases, Map<String, String> weights) {
        String rel = node.getRelation().getBase();
        String index = node.getIndex().toLowerCase();
        Vector modifiers = node.getRelation().getModifiers();
        UnaryFunction<String, String> valueTransformer = valueTranformerMap.transformerFor(index);
        String term = (String)valueTransformer.evaluate((Object)node.getTerm());
        if (!index.equals("")) {
            if (modifiers.size() > 0) {
                rel = ((Modifier)modifiers.firstElement()).getType();
            }
            if (Relations.contains(rel)) {
                return LuceneCqlTranslator.buildTerm(cqlOptions, rel, index, term, aliases, weights);
            }
            throw new RuntimeException("unknow relation: " + rel);
        }
        throw new RuntimeException("invalid field: " + index);
    }

    private static TranslatedQuery buildTerm(Map<String, List<String>> cqlOptions, String rel, String index, String term, BiMap<String, String> aliases, Map<String, String> weights) {
        return new TranslatedQuery(new TermNode(index, Relations.get(rel), term, cqlOptions, aliases, weights), new QueryOptions());
    }
}

