package eu.dnetlib.data.information.oai.publisher;

import eu.dnetlib.data.information.oai.publisher.OAIController.DELETED_SUPPORT;

public class OAIProperties {

	/**
	 * forwarded url header name, default "X-Forwarded-Url".
	 */
	private String forwardedUrlHeaderName = "X-Forwarded-Url";

	/**
	 * optional base url. If present it overrides the X-Forwarded-Url.
	 */
	private String baseUrl;
	private String repoName = "Driver Service for supporting Open Archive Initiative requests";
	private String repoEmail = "artini@isti.cnr.it";
	private String earliestDatestamp = "1970-01-01";
	private DELETED_SUPPORT deletedRecordSupport;
	private String dateGranularity = "YYYY-MM-DD";

	public String getBaseUrl() {
		return baseUrl;
	}

	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

	public String getRepoName() {
		return repoName;
	}

	public void setRepoName(String repoName) {
		this.repoName = repoName;
	}

	public String getRepoEmail() {
		return repoEmail;
	}

	public void setRepoEmail(String repoEmail) {
		this.repoEmail = repoEmail;
	}

	public String getEarliestDatestamp() {
		return earliestDatestamp;
	}

	public void setEarliestDatestamp(String earliestDatestamp) {
		this.earliestDatestamp = earliestDatestamp;
	}

	public String getDeletedRecordSupport() {
		return deletedRecordSupport.toString();
	}

	public void setDeletedRecordSupport(String deletedRecordSupport) {
		this.deletedRecordSupport = DELETED_SUPPORT.valueOf(deletedRecordSupport.trim().toUpperCase());
	}

	public String getDateGranularity() {
		return dateGranularity;
	}

	public void setDateGranularity(String dateGranularity) {
		this.dateGranularity = dateGranularity;
	}

	public String getForwardedUrlHeaderName() {
		return forwardedUrlHeaderName;
	}

	public void setForwardedUrlHeaderName(String forwardedUrlHeaderName) {
		this.forwardedUrlHeaderName = forwardedUrlHeaderName;
	}

}
