package eu.dnetlib.data.information.oai.publisher;

public enum OAIError {
	badArgument {

		@Override
		public String getMessage() {
			return "The request includes illegal arguments, is missing required arguments, includes a repeated argument, or values for arguments have an illegal syntax.";
		}
	},
	badVerb {

		@Override
		public String getMessage() {
			return "Value of the verb argument is not a legal OAI-PMH verb, the verb argument is missing, or the verb argument is repeated.";
		}
	},
	cannotDisseminateFormat {

		@Override
		public String getMessage() {
			return "The metadata format identified by the value given for the metadataPrefix argument is not supported by the item or by the repository.";
		}
	},
	idDoesNotExist {

		@Override
		public String getMessage() {
			return "The value of the identifier argument is unknown or illegal in this repository.";
		}
	},
	noMetadataFormats {

		@Override
		public String getMessage() {
			return "There are no metadata formats available for the specified item.";
		}
	},
	noSetHierarchy {

		@Override
		public String getMessage() {
			return "The repository does not support sets.";
		}
	},
	noRecordsMatch {

		@Override
		public String getMessage() {
			return "The combination of the values of the from, until, set and metadataPrefix arguments results in an empty list.";
		}
	},
	badResumptionToken {

		@Override
		public String getMessage() {
			return "The value of the resumptionToken argument is invalid or expired.";
		}
	};

	public abstract String getMessage();

}
