/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher;

import eu.dnetlib.data.information.oai.publisher.BadResumptionTokenException;
import eu.dnetlib.data.information.oai.publisher.CannotDisseminateFormatException;
import eu.dnetlib.data.information.oai.publisher.NoRecordsMatchException;
import eu.dnetlib.data.information.oai.publisher.OAIError;
import eu.dnetlib.data.information.oai.publisher.OAIProperties;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.core.AbstractOAICore;
import eu.dnetlib.data.information.oai.publisher.info.ListRecordsInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public final class OAIController {
    private static final Log log = LogFactory.getLog(OAIController.class);
    private static final String DEFAULT_CONTENT_TYPE = "text/xml;charset=utf-8";
    @Autowired
    private AbstractOAICore core;
    @Autowired
    private OAIProperties oaiProperties;

    @RequestMapping(value={"/oai/clearCaches.do"})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearOaiCaches() throws OaiPublisherException {
        this.core.getMdFormatsCache().clear();
        this.core.setCurrentDBFromIS();
        this.core.getLookupClient().evictCaches();
    }

    @RequestMapping(value={"/oai/oai.do"})
    public String oai(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(DEFAULT_CONTENT_TYPE);
        String theVerb = "";
        try {
            Map<String, String> params = this.cleanParameters(request.getParameterMap());
            if (params == null) {
                return this.oaiError(OAIError.badArgument, map);
            }
            theVerb = params.get("verb");
            OAI_VERBS requestedVerb = OAI_VERBS.getVerb(theVerb);
            switch (requestedVerb) {
                case IDENTIFY: {
                    return this.oaiIdentify(params, map);
                }
                case LIST_METADATA_FORMATS: {
                    return this.oaiListMetadataFormats(params, map);
                }
                case LIST_SETS: {
                    return this.oaiListSets(params, map);
                }
                case GET_RECORD: {
                    return this.oaiGetRecord(params, map);
                }
                case LIST_IDENTIFIERS: {
                    return this.oaiListIdentifiersOrRecords(params, map);
                }
                case LIST_RECORDS: {
                    return this.oaiListIdentifiersOrRecords(params, map);
                }
            }
            return this.oaiError(OAIError.badVerb, map);
        }
        catch (CannotDisseminateFormatException e) {
            log.debug((Object)("Exception: " + e.getMessage()));
            return this.oaiError(OAIError.cannotDisseminateFormat, theVerb, map);
        }
        catch (NoRecordsMatchException e) {
            log.debug((Object)("Exception: " + e.getMessage()));
            return this.oaiError(OAIError.noRecordsMatch, theVerb, map);
        }
        catch (BadResumptionTokenException e) {
            log.debug((Object)("Exception: " + e.getMessage()));
            return this.oaiError(OAIError.badResumptionToken, theVerb, map);
        }
        catch (Exception e) {
            log.error((Object)("ERROR for request " + request.getRequestURL()), (Throwable)e);
            return this.oaiError(e, map);
        }
    }

    private Map<String, String> cleanParameters(Map<?, ?> startParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : startParams.entrySet()) {
            String key = entry.getKey().toString();
            String[] arr = (String[])entry.getValue();
            if (arr.length == 0) {
                return null;
            }
            String value = arr[0];
            if (key.equals("verb")) {
                params.put("verb", value);
                continue;
            }
            if (key.equals("from")) {
                params.put("from", value);
                continue;
            }
            if (key.equals("until")) {
                params.put("until", value);
                continue;
            }
            if (key.equals("metadataPrefix")) {
                params.put("metadataPrefix", value);
                continue;
            }
            if (key.equals("identifier")) {
                params.put("identifier", value);
                continue;
            }
            if (key.equals("set")) {
                params.put("set", value);
                continue;
            }
            if (key.equals("resumptionToken")) {
                params.put("resumptionToken", value);
                continue;
            }
            return null;
        }
        return params;
    }

    private String oaiIdentify(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError(OAIError.badArgument, verb, map);
        }
        return "oai/OAI_Identify";
    }

    private String oaiGetRecord(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        String prefix = null;
        String identifier = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (!params.containsKey("metadataPrefix")) {
            return this.oaiError(OAIError.badArgument, verb, map);
        }
        prefix = params.get("metadataPrefix");
        params.remove("metadataPrefix");
        if (!params.containsKey("identifier")) {
            return this.oaiError(OAIError.badArgument, verb, map);
        }
        identifier = params.get("identifier");
        params.remove("identifier");
        if (params.entrySet().size() > 0) {
            return this.oaiError(OAIError.badArgument, verb, map);
        }
        this.core.setCurrentDBFromIS();
        RecordInfo record = this.core.getInfoRecord(identifier, prefix);
        if (record == null) {
            return this.oaiError(OAIError.idDoesNotExist, map);
        }
        map.addAttribute("record", (Object)record);
        return "oai/OAI_GetRecord";
    }

    private String oaiListIdentifiersOrRecords(Map<String, String> params, ModelMap map) throws Exception {
        OAI_VERBS verb = null;
        String metadataPrefix = null;
        String resumptionToken = null;
        String set = null;
        String from = null;
        String until = null;
        if (params.containsKey("verb")) {
            verb = OAI_VERBS.getVerb(params.get("verb"));
            params.remove("verb");
        }
        if (params.containsKey("resumptionToken")) {
            resumptionToken = params.get("resumptionToken");
            params.remove("resumptionToken");
            this.core.setCurrentDBFromIS();
        } else {
            this.core.setCurrentDBFromIS();
            if (!params.containsKey("metadataPrefix")) {
                return this.oaiError(OAIError.badArgument, verb.toString(), map);
            }
            metadataPrefix = params.get("metadataPrefix");
            params.remove("metadataPrefix");
            if (params.containsKey("from")) {
                from = params.get("from");
                params.remove("from");
            }
            if (params.containsKey("until")) {
                until = params.get("until");
                params.remove("until");
            }
            if (params.containsKey("set")) {
                set = params.get("set");
                params.remove("set");
            }
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError(OAIError.badArgument, verb.toString(), map);
        }
        if (StringUtils.isNotBlank(set) && !this.core.existSet(set)) {
            return this.oaiError(OAIError.badArgument, verb.toString(), map);
        }
        boolean onlyIdentifiers = true;
        if (verb == OAI_VERBS.LIST_RECORDS) {
            onlyIdentifiers = false;
        }
        long start = System.currentTimeMillis();
        ListRecordsInfo infos = StringUtils.isBlank((CharSequence)resumptionToken) ? this.core.listRecords(onlyIdentifiers, metadataPrefix, set, from, until) : this.core.listRecords(onlyIdentifiers, resumptionToken);
        map.addAttribute("info", (Object)infos);
        long end = System.currentTimeMillis();
        log.debug((Object)("Populated map for client in (ms): " + (end - start)));
        if (verb == OAI_VERBS.LIST_RECORDS) {
            return "oai/OAI_ListRecords";
        }
        return "oai/OAI_ListIdentifiers";
    }

    private String oaiListSets(Map<String, String> params, ModelMap map) throws Exception {
        String verb = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError(OAIError.badArgument, verb, map);
        }
        this.core.setCurrentDBFromIS();
        map.addAttribute("sets", this.core.listSets());
        return "oai/OAI_ListSets";
    }

    private String oaiListMetadataFormats(Map<String, String> params, ModelMap map) throws Exception {
        String id = null;
        String verb = null;
        if (params.containsKey("verb")) {
            verb = params.get("verb");
            params.remove("verb");
        }
        if (params.containsKey("identifier")) {
            id = params.get("identifier");
            params.remove("identifier");
        }
        if (params.entrySet().size() > 0) {
            return this.oaiError(OAIError.badArgument, verb, map);
        }
        this.core.setCurrentDBFromIS();
        map.addAttribute("formats", this.core.listMetadataFormats());
        if (id != null) {
            map.addAttribute("identifier", (Object)id);
            return "oai/OAI_ListMetadataFormats_withid";
        }
        return "oai/OAI_ListMetadataFormats";
    }

    private String oaiError(OAIError errCode, String verb, ModelMap map) throws Exception {
        if (StringUtils.isBlank((CharSequence)verb)) {
            return this.oaiError(errCode, map);
        }
        map.addAttribute("verb", (Object)verb);
        map.addAttribute("errcode", (Object)errCode.name());
        map.addAttribute("errmsg", (Object)errCode.getMessage());
        return "oai/OAI_Error";
    }

    private String oaiError(OAIError errCode, ModelMap map) throws Exception {
        map.addAttribute("errcode", (Object)errCode.name());
        map.addAttribute("errmsg", (Object)errCode.getMessage());
        return "oai/OAI_Error_noverb";
    }

    private String oaiError(Exception e, ModelMap map) throws Exception {
        map.addAttribute("errcode", (Object)"InternalException");
        map.addAttribute("errmsg", (Object)e.getMessage());
        return "oai/OAI_Error_noverb";
    }

    @ModelAttribute(value="url")
    public String url(HttpServletRequest request) {
        String forwardedUrl = request.getHeader(this.getForwardedUrlHeaderName());
        String baseURL = this.getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)baseURL)) {
            return baseURL;
        }
        if (StringUtils.isNotBlank((CharSequence)forwardedUrl)) {
            return forwardedUrl;
        }
        return request.getRequestURL() + "";
    }

    @ModelAttribute(value="date")
    public String date() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = formatter.format(new Date());
        return date.replace("+0000", "Z");
    }

    @ModelAttribute(value="repoName")
    public String getRepoName() {
        return this.oaiProperties.getRepoName();
    }

    @ModelAttribute(value="email")
    public String getRepoEmail() {
        return this.oaiProperties.getRepoEmail();
    }

    @ModelAttribute(value="earliestDatestamp")
    public String getEarliestDatestamp() {
        return this.oaiProperties.getEarliestDatestamp();
    }

    public String getBaseUrl() {
        return this.oaiProperties.getBaseUrl();
    }

    public String getForwardedUrlHeaderName() {
        return this.oaiProperties.getForwardedUrlHeaderName();
    }

    @ModelAttribute(value="deletedRecord")
    public String getDeletedRecordSupport() {
        return this.oaiProperties.getDeletedRecordSupport();
    }

    @ModelAttribute(value="granularity")
    public String getDateGranularity() {
        return this.oaiProperties.getDateGranularity();
    }

    public static enum DELETED_SUPPORT {
        NO,
        TRANSIENT,
        PERSISTENT;


        public String toString() {
            switch (this) {
                case TRANSIENT: {
                    return "transient";
                }
                case PERSISTENT: {
                    return "persistent";
                }
            }
            return "no";
        }
    }

    public static enum OAI_VERBS {
        IDENTIFY,
        LIST_IDENTIFIERS,
        LIST_RECORDS,
        LIST_METADATA_FORMATS,
        LIST_SETS,
        GET_RECORD,
        UNSUPPORTED_VERB;


        public static OAI_VERBS getVerb(String theVerb) {
            if (StringUtils.isBlank((CharSequence)theVerb)) {
                return UNSUPPORTED_VERB;
            }
            if (theVerb.equalsIgnoreCase("Identify")) {
                return IDENTIFY;
            }
            if (theVerb.equalsIgnoreCase("ListIdentifiers")) {
                return LIST_IDENTIFIERS;
            }
            if (theVerb.equalsIgnoreCase("ListRecords")) {
                return LIST_RECORDS;
            }
            if (theVerb.equalsIgnoreCase("ListMetadataFormats")) {
                return LIST_METADATA_FORMATS;
            }
            if (theVerb.equalsIgnoreCase("ListSets")) {
                return LIST_SETS;
            }
            if (theVerb.equalsIgnoreCase("GetRecord")) {
                return GET_RECORD;
            }
            if (theVerb.equalsIgnoreCase("listidentifiers")) {
                return LIST_IDENTIFIERS;
            }
            return UNSUPPORTED_VERB;
        }
    }
}

