/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import eu.dnetlib.data.information.oai.publisher.CannotDisseminateFormatException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.conf.ISLookUpClient;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationExistReader;
import eu.dnetlib.data.information.oai.publisher.info.ListDocumentsInfo;
import eu.dnetlib.data.information.oai.publisher.info.ListRecordsInfo;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.info.ResumptionToken;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.sets.SetCollection;
import eu.dnetlib.miscutils.cache.EhCache;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractOAICore {
    private static final Log log = LogFactory.getLog(AbstractOAICore.class);
    private String currentDBName;
    @Autowired
    private SetCollection setCollection;
    @Autowired
    private OAIConfigurationExistReader oaiConfigurationExistReader;
    @Autowired
    private ISLookUpClient lookupClient;
    @Resource
    private EhCache<String, MDFInfo> mdFormatsCache;
    protected int pageSize = 100;

    public RecordInfo getInfoRecord(String identifier, String prefix) throws OaiPublisherException {
        MDFInfo mdf = this.obtainMDFInfo(prefix);
        return this.getRecordById(mdf, identifier);
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String metadataPrefix, String set, String from, String until) throws OaiPublisherException {
        ListRecordsInfo res = new ListRecordsInfo();
        if (from != null) {
            res.setFrom(from);
            res.setWithSize(false);
        }
        if (until != null) {
            res.setUntil(until);
            res.setWithSize(false);
        }
        if (metadataPrefix != null) {
            res.setMetadataprefix(metadataPrefix);
        }
        if (set != null) {
            res.setSet(set);
        }
        ListDocumentsInfo documents = this.getDocuments(onlyIdentifiers, set, metadataPrefix, from, until);
        ResumptionToken resumptionToken = documents.getResumptionToken();
        int cursor = documents.getCursor();
        int nMaxElements = documents.getnMaxElements();
        if (onlyIdentifiers) {
            res.setIdentifiers(documents.getDocs());
        } else {
            res.setDocuments(documents.getDocs());
        }
        if (resumptionToken != null) {
            res.setResumptiontoken(resumptionToken.serialize());
            res.setCursor(cursor);
            res.setSize(nMaxElements);
        }
        return res;
    }

    public ListRecordsInfo listRecords(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ListDocumentsInfo docs = this.getDocuments(onlyIdentifiers, resumptionToken);
        ListRecordsInfo res = new ListRecordsInfo();
        if (docs.getMetadataPrefix() != null) {
            res.setMetadataprefix(docs.getMetadataPrefix());
        }
        if (onlyIdentifiers) {
            res.setIdentifiers(docs.getDocs());
        } else {
            res.setDocuments(docs.getDocs());
        }
        ResumptionToken newResumptionToken = docs.getResumptionToken();
        if (newResumptionToken != null) {
            res.setResumptiontoken(newResumptionToken.serialize());
            res.setCursor(docs.getCursor());
            res.setSize(docs.getnMaxElements());
            res.setWithSize(!newResumptionToken.hasDateRange());
        }
        return res;
    }

    public List<? extends SetInfo> listSets() {
        return this.setCollection.getAllSets(true, this.getCurrentDBName());
    }

    public List<MDFInfo> listMetadataFormats() {
        return this.oaiConfigurationExistReader.getMetadataFormatInfo(true);
    }

    public boolean existSet(String setSpec) {
        return this.setCollection.containEnabledSet(setSpec, this.getCurrentDBName());
    }

    protected MDFInfo obtainMDFInfo(String metadataPrefix) throws OaiPublisherException {
        MDFInfo mdf = (MDFInfo)this.mdFormatsCache.get((Object)metadataPrefix);
        if (mdf == null) {
            log.fatal((Object)("Not using cache for " + metadataPrefix));
            mdf = this.oaiConfigurationExistReader.getMetadataFormatInfo(metadataPrefix);
            if (mdf == null) {
                throw new CannotDisseminateFormatException("Invalid metadataPrefix " + metadataPrefix);
            }
            this.mdFormatsCache.put((Object)metadataPrefix, (Object)mdf);
        }
        return mdf;
    }

    public void setCurrentDBFromIS() throws OaiPublisherException {
        try {
            this.currentDBName = this.getLookupClient().getCurrentDB();
        }
        catch (Exception e) {
            throw new OaiPublisherException(e);
        }
    }

    protected abstract RecordInfo getRecordById(MDFInfo var1, String var2) throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2, String var3, String var4, String var5) throws OaiPublisherException;

    protected abstract ListDocumentsInfo getDocuments(boolean var1, String var2) throws OaiPublisherException;

    public String getCurrentDBName() {
        return this.currentDBName;
    }

    public void setCurrentDBName(String currentDBName) {
        this.currentDBName = currentDBName;
    }

    public SetCollection getSetCollection() {
        return this.setCollection;
    }

    public void setSetCollection(SetCollection setCollection) {
        this.setCollection = setCollection;
    }

    public OAIConfigurationExistReader getOaiConfigurationExistReader() {
        return this.oaiConfigurationExistReader;
    }

    public void setOaiConfigurationExistReader(OAIConfigurationExistReader oaiConfigurationExistReader) {
        this.oaiConfigurationExistReader = oaiConfigurationExistReader;
    }

    public ISLookUpClient getLookupClient() {
        return this.lookupClient;
    }

    public void setLookupClient(ISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }

    public EhCache<String, MDFInfo> getMdFormatsCache() {
        return this.mdFormatsCache;
    }

    public void setMdFormatsCache(EhCache<String, MDFInfo> mdFormatsCache) {
        this.mdFormatsCache = mdFormatsCache;
    }
}

