/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utility.cleaner;

import eu.dnetlib.data.utility.cleaner.XPATHCleaningRule;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerException;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroovyRule
extends XPATHCleaningRule {
    private static final Log log = LogFactory.getLog(GroovyRule.class);
    private String groovyRule;
    private Closure<String> closure;
    private GroovyShell groovyShell = new GroovyShell();

    public GroovyRule(String groovyRule) {
        this.groovyRule = groovyRule;
        this.closure = (Closure)this.groovyShell.evaluate("{ input -> " + groovyRule + "}");
    }

    @Override
    protected String calculateNewValue(String oldValue) throws CleanerException {
        try {
            log.info((Object)("Executing groovy closure on value " + oldValue));
            return (String)this.closure.call((Object)oldValue);
        }
        catch (Exception e) {
            log.error((Object)("Failed Groovy execution, groovyRule: " + this.groovyRule + ", input: " + oldValue), (Throwable)e);
            throw new CleanerException("Error executing groovy", (Throwable)e);
        }
    }

    @Override
    protected Map<String, String> verifyValue(String value) throws CleanerException {
        return null;
    }

    public String toString() {
        return "GROOVY: " + this.groovyRule;
    }
}

