package eu.dnetlib.enabling.database.resultset;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.enabling.database.utils.DatabaseUtils;

public class LoggedTableDumperResultSetListener extends SQLResultSetListener {

	protected LoggedTableDumperResultSetListener(String db, String table, Date from, Date until, DatabaseUtils dbUtils) {
		super();
		setDb(db);
		setDbUtils(dbUtils);
		
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("from", from);
		map.put("to", until);
		
		setSql(dbUtils.getSQLFromTemplate("loggedTable", db, table, map));
	}

}
