/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database;

import eu.dnetlib.enabling.database.DatabaseBlackBoardNotificationHandler;
import eu.dnetlib.enabling.database.DatabaseServiceCore;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DatabaseServiceImpl
extends AbstractBaseService
implements DatabaseService {
    private static final Log log = LogFactory.getLog(DatabaseServiceImpl.class);
    private DatabaseServiceCore core;
    private XSLTMappedResultSetFactory xsltResultsetFactory;
    private DatabaseBlackBoardNotificationHandler blackBoardNotificationHandler;
    private ExecutorService threadPool = Executors.newCachedThreadPool();

    public W3CEndpointReference dumpTable(String db, String table) throws DatabaseException {
        try {
            return this.core.generateResultSet(db, table, null);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public W3CEndpointReference dumpTableAndLogs(String db, String table, Date from, Date until) throws DatabaseException {
        try {
            return this.core.generateResultSet(db, table, from, until);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        log.info((Object)("Received notification " + subscriptionId + ", TOPIC: " + topic));
        if (topic.contains("BLACKBOARD")) {
            this.blackBoardNotificationHandler.notified(subscriptionId, topic, isId, message);
            return;
        }
    }

    public void importFromEPR(final String db, W3CEndpointReference epr, String xslt) throws DatabaseException {
        final W3CEndpointReference mappedEpr = xslt == null || xslt.isEmpty() ? epr : this.xsltResultsetFactory.createMappedResultSet(epr, xslt);
        try {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        DatabaseServiceImpl.this.core.importFromResultset(db, mappedEpr);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error in thread when importing from epr", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Required
    public void setCore(DatabaseServiceCore core) {
        this.core = core;
    }

    public W3CEndpointReference searchSQL(String db, String sql) throws DatabaseException {
        try {
            return this.core.generateResultSet(db, sql);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public W3CEndpointReference alternativeSearchSQL(String db, String sql, String sqlForSize) throws DatabaseException {
        try {
            return this.core.generateResultsetWithSize(db, sql, sqlForSize);
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    public void updateSQL(String db, String sql) throws DatabaseException {
        this.core.getDbUtils().executeSql(db, sql);
    }

    public W3CEndpointReference xsltSearchSQL(String db, String sql, String xslt) throws DatabaseException {
        try {
            return this.xsltResultsetFactory.createMappedResultSet(this.searchSQL(db, sql), xslt);
        }
        catch (Throwable e) {
            throw new DatabaseException("Error returning a transformed resultSet", e);
        }
    }

    public W3CEndpointReference alternativeXsltSearchSQL(String db, String sql, String sqlForSize, String xslt) throws DatabaseException {
        try {
            return this.xsltResultsetFactory.createMappedResultSet(this.alternativeSearchSQL(db, sql, sqlForSize), xslt);
        }
        catch (Throwable e) {
            throw new DatabaseException("Error returning a transformed resultSet", e);
        }
    }

    public boolean contains(String db, String table, String column, String value) throws DatabaseException {
        return this.core.getDbUtils().contains(db, table, column, value);
    }

    public XSLTMappedResultSetFactory getXsltResultsetFactory() {
        return this.xsltResultsetFactory;
    }

    @Required
    public void setXsltResultsetFactory(XSLTMappedResultSetFactory xsltResultsetFactory) {
        this.xsltResultsetFactory = xsltResultsetFactory;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public DatabaseBlackBoardNotificationHandler getBlackBoardNotificationHandler() {
        return this.blackBoardNotificationHandler;
    }

    @Required
    public void setBlackBoardNotificationHandler(DatabaseBlackBoardNotificationHandler blackBoardNotificationHandler) {
        this.blackBoardNotificationHandler = blackBoardNotificationHandler;
    }
}

