/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database;

import eu.dnetlib.enabling.database.DataSourceFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class DataSourceFactoryImpl
implements DataSourceFactory {
    private String driverClassName;
    private String baseUrl;
    private String username;
    private String password;

    @Override
    public DataSource createDataSource(String db) {
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setDriverClassName(this.driverClassName);
        ds.setUrl(this.baseUrl + "/" + db);
        ds.setUsername(this.username);
        ds.setPassword(this.password);
        return ds;
    }

    @Required
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @Required
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Required
    public void setUsername(String username) {
        this.username = username;
    }

    @Required
    public void setPassword(String password) {
        this.password = password;
    }
}

