/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database;

import eu.dnetlib.enabling.database.DatabaseServiceImpl;
import eu.dnetlib.enabling.database.objects.DnetDatabase;
import eu.dnetlib.enabling.database.resultset.SQLResultSetListenerFactory;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.sn.rmi.ISSNException;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.util.Date;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DatabaseServiceCore {
    private DatabaseUtils dbUtils;
    private ResultSetFactory resultSetFactory;
    private SQLResultSetListenerFactory resultSetListenerFactory;
    private ResultSetClientFactory clientResultSetFactory;
    private static final Log log = LogFactory.getLog(DatabaseServiceImpl.class);

    public List<DnetDatabase> listDatabases() throws DatabaseException {
        return this.dbUtils.listAllDatabases();
    }

    public void changeDatabaseStatus(String dbName, boolean managed) throws DatabaseException, ISRegistryException, ISSNException {
        log.info((Object)("Changing management status of db " + dbName + ", new value: " + managed));
        for (String tname : this.dbUtils.listCommonDBTables(dbName)) {
            if (managed) {
                this.dbUtils.prepareManagementOfTable(dbName, tname);
                continue;
            }
            this.dbUtils.removeManagementOfTable(dbName, tname);
        }
        this.dbUtils.setManaged(dbName, managed);
    }

    public void importFromResultset(String db, W3CEndpointReference epr) throws DatabaseException {
        this.importFromIterable(db, (Iterable<String>)this.clientResultSetFactory.getClient(epr));
    }

    public void importFromIterable(String db, Iterable<String> iter) throws DatabaseException {
        this.dbUtils.importFromIterable(db, iter);
    }

    public W3CEndpointReference generateResultSet(String db, String t, String where) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createCondTableListener(db, t, where));
    }

    public W3CEndpointReference generateResultSet(String db, String t, Date from, Date until) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createLoggedTableListener(db, t, from, until));
    }

    public W3CEndpointReference generateResultSet(String db, String sql) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createSQLListener(db, sql));
    }

    public W3CEndpointReference generateResultsetWithSize(String db, String sql, String sqlForSize) {
        return this.resultSetFactory.createResultSet(this.resultSetListenerFactory.createSQLListenerWithSize(db, sql, sqlForSize));
    }

    @Required
    public void setDbUtils(DatabaseUtils dbUtils) {
        this.dbUtils = dbUtils;
    }

    public DatabaseUtils getDbUtils() {
        return this.dbUtils;
    }

    @Required
    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    @Required
    public void setClientResultSetFactory(ResultSetClientFactory clientResultSetFactory) {
        this.clientResultSetFactory = clientResultSetFactory;
    }

    public ResultSetClientFactory getClientResultSetFactory() {
        return this.clientResultSetFactory;
    }

    @Required
    public void setResultSetListenerFactory(SQLResultSetListenerFactory resultSetListenerFactory) {
        this.resultSetListenerFactory = resultSetListenerFactory;
    }

    public SQLResultSetListenerFactory getResultSetListenerFactory() {
        return this.resultSetListenerFactory;
    }
}

