/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database;

import com.google.gson.Gson;
import eu.dnetlib.enabling.database.DatabaseServiceCore;
import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DatabaseBlackBoardNotificationHandler
extends AbstractBlackboardNotificationHandler<BlackboardServerHandler>
implements NotificationHandler {
    private static final Log log = LogFactory.getLog(DatabaseBlackBoardNotificationHandler.class);
    private DatabaseServiceCore core;
    private ExecutorService threadPool = Executors.newCachedThreadPool();
    private XSLTMappedResultSetFactory xsltResultsetFactory;

    protected void processJob(final BlackboardJob job) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DatabaseBlackBoardNotificationHandler.this.processJobInternal(job);
                }
                catch (Throwable e) {
                    log.error((Object)e.getMessage(), e);
                    ((BlackboardServerHandler)DatabaseBlackBoardNotificationHandler.this.getBlackboardHandler()).failed(job, e);
                }
            }
        });
    }

    private void processJobInternal(BlackboardJob job) throws DatabaseException {
        String action = job.getAction();
        log.info((Object)("processing database job: " + action));
        if (action.equals("IMPORT")) {
            String db = (String)job.getParameters().get("db");
            String epr = this.decodeBase64((String)job.getParameters().get("epr"));
            String xslt = this.decodeBase64((String)job.getParameters().get("xslt"));
            String xsltParamsString = this.decodeBase64((String)job.getParameters().get("xsltParams"));
            Map xsltParams = null;
            if (xsltParamsString != null && !xsltParamsString.isEmpty()) {
                xsltParams = (Map)new Gson().fromJson(xsltParamsString, Map.class);
            }
            if (db == null || db.isEmpty() || epr == null || epr.isEmpty()) {
                throw new IllegalArgumentException("Some needed params are null or empty.");
            }
            W3CEndpointReference eprObject = new EPRUtils().getEpr(epr);
            W3CEndpointReference mappedEpr = null;
            mappedEpr = xslt == null || xslt.isEmpty() ? eprObject : (xsltParams == null || xsltParams.isEmpty() ? this.xsltResultsetFactory.createMappedResultSet(eprObject, xslt) : this.xsltResultsetFactory.createMappedResultSet(eprObject, xslt, xsltParams));
            this.core.importFromResultset(db, mappedEpr);
            ((BlackboardServerHandler)this.getBlackboardHandler()).done(job);
            log.info((Object)"IMPORT job set to DONE");
        } else if (action.equals("EXEC")) {
            String db = (String)job.getParameters().get("db");
            String sql = (String)job.getParameters().get("sql");
            if (db == null || db.isEmpty() || sql == null || sql.isEmpty()) {
                throw new IllegalArgumentException("Some needed params are null or empty.");
            }
            log.info((Object)("EXECUTING SCRIPT: " + sql + " on " + db));
            this.core.getDbUtils().executeSql(db, sql);
            ((BlackboardServerHandler)this.getBlackboardHandler()).done(job);
            log.info((Object)"SCRIPT COMPLETED");
        } else {
            throw new IllegalArgumentException("unsupported message action: " + action);
        }
    }

    private String decodeBase64(String s) {
        if (s != null && Base64.isBase64((byte[])s.getBytes())) {
            return new String(Base64.decodeBase64((byte[])s.getBytes()));
        }
        return s;
    }

    public DatabaseServiceCore getCore() {
        return this.core;
    }

    @Required
    public void setCore(DatabaseServiceCore core) {
        this.core = core;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public XSLTMappedResultSetFactory getXsltResultsetFactory() {
        return this.xsltResultsetFactory;
    }

    @Required
    public void setXsltResultsetFactory(XSLTMappedResultSetFactory xsltResultsetFactory) {
        this.xsltResultsetFactory = xsltResultsetFactory;
    }
}

