/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.resultset;

import eu.dnetlib.enabling.database.resultset.IterableSQLResultSetListener;
import eu.dnetlib.enabling.database.resultset.LoggedTableDumperResultSetListener;
import eu.dnetlib.enabling.database.resultset.TableDumperResultSetListener;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.util.Date;
import org.springframework.beans.factory.annotation.Required;

public class SQLResultSetListenerFactory {
    private DatabaseUtils dbUtils;

    public ResultSetListener createSQLListener(String db, String sql) {
        return new IterableSQLResultSetListener(db, sql, this.dbUtils);
    }

    public ResultSetListener createSQLListenerWithSize(String db, String sql, String sqlForSize) {
        return new IterableSQLResultSetListener(db, sql, sqlForSize, this.dbUtils);
    }

    public ResultSetListener createTableListener(String db, String table) {
        return new TableDumperResultSetListener(db, table, null, this.dbUtils);
    }

    public ResultSetListener createCondTableListener(String db, String table, String where) {
        return new TableDumperResultSetListener(db, table, where, this.dbUtils);
    }

    public ResultSetListener createLoggedTableListener(String db, String table, Date from, Date until) {
        return new LoggedTableDumperResultSetListener(db, table, from, until, this.dbUtils);
    }

    @Required
    public void setDbUtils(DatabaseUtils dbUtils) {
        this.dbUtils = dbUtils;
    }
}

