/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.hcm.sn;

import eu.dnetlib.enabling.actions.SubscriptionAction;
import eu.dnetlib.enabling.hcm.sn.HCMSubscriber;
import eu.dnetlib.enabling.is.sn.rmi.ISSNException;
import eu.dnetlib.enabling.is.sn.rmi.ISSNService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class HCMSubscriberImpl
implements HCMSubscriber {
    private static final Log log = LogFactory.getLog(HCMSubscriberImpl.class);
    private Endpoint endpoint;
    private UniqueServiceLocator serviceLocator;
    @Resource(name="jaxwsEndpointReferenceBuilder")
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private List<SubscriptionAction> actions;

    @PostConstruct
    public void printList() {
        log.info(this.getActions());
    }

    @Override
    public void subscribeAll() throws ISSNException {
        W3CEndpointReference endpointReference = this.eprBuilder.getEndpointReference((Object)this.getEndpoint());
        if (this.getActions() != null) {
            for (SubscriptionAction action : this.getActions()) {
                log.info((Object)("dynamically subscribing to " + action.getTopicExpression()));
                ((ISSNService)this.serviceLocator.getService(ISSNService.class, true)).subscribe(endpointReference, action.getTopicExpression(), 0);
            }
        }
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    public List<SubscriptionAction> getActions() {
        return this.actions;
    }

    @Required
    public void setActions(List<SubscriptionAction> actions) {
        this.actions = actions;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

