/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.enabling.is.sn.SubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.SubscriptionRequest;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.rmi.ISSNException;
import eu.dnetlib.enabling.is.sn.rmi.SubscriptionRequestRejectedException;
import eu.dnetlib.enabling.tools.UniqueIdentifierGenerator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGeneratorImpl;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ISSNServiceCore {
    private static final Log log = LogFactory.getLog(ISSNServiceCore.class);
    private SubscriptionRegistry registry;
    private UniqueIdentifierGenerator uuidGenerator = new UniqueIdentifierGeneratorImpl("sn");
    private String backupDir;

    public String subscribe(W3CEndpointReference consumerReference, String topicExpression, int ttl) throws SubscriptionRequestRejectedException {
        log.debug((Object)"subscribing");
        SubscriptionRequest srq = new SubscriptionRequest(this.uuidGenerator.generateIdentifier(), consumerReference, topicExpression, ttl);
        String subId = this.getRegistry().registerSubscription(srq);
        if (subId != null) {
            return subId;
        }
        return null;
    }

    public boolean unsubscribe(String subscrId) {
        return this.getRegistry().unsubscribe(subscrId);
    }

    public String backup() throws ISSNException {
        log.info((Object)"Starting backup...");
        try {
            this.verifyBackupDir();
            String seq = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(this.backupDir + "/data-" + seq + ".zip"));
            FileWriter logFile = new FileWriter(this.backupDir + "/report-" + seq + ".log");
            logFile.write("Backup started at: " + DateUtils.now_ISO8601() + "\n\n");
            this.backup(zip, logFile);
            logFile.write("\nBackup finished at: " + DateUtils.now_ISO8601() + "\n");
            logFile.flush();
            logFile.close();
            zip.flush();
            zip.close();
            log.info((Object)"Backup finished");
            return this.backupDir;
        }
        catch (Exception e) {
            log.error((Object)"Backup failed", (Throwable)e);
            throw new ISSNException("cannot backup", (Throwable)e);
        }
    }

    private void backup(ZipOutputStream zip, FileWriter logFile) throws IOException {
        for (ResourceStateSubscription sub : this.getRegistry().listSubscriptions()) {
            logFile.write("SUBSCRIPTION: " + sub.getSubscriptionId() + "\n");
            log.info((Object)("Backup of subscription: " + sub.getSubscriptionId()));
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("prefix", sub.getPrefix());
            attrs.put("type", sub.getType());
            attrs.put("resourceId", sub.getResourceId());
            attrs.put("xpath", sub.getXpath());
            attrs.put("id", sub.getSubscriptionId());
            attrs.put("subscriber", sub.getSubscriber().toString());
            zip.putNextEntry(new ZipEntry(sub.getSubscriptionId()));
            zip.write(this.encodeJSon(attrs).getBytes());
            zip.closeEntry();
        }
    }

    private String encodeJSon(Map<String, String> map) {
        return new Gson().toJson(map, new TypeToken<Map<String, String>>(){}.getType());
    }

    private void verifyBackupDir() {
        File d = new File(this.backupDir);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    public UniqueIdentifierGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UniqueIdentifierGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    @Required
    public void setBackupDir(String backupDir) {
        this.backupDir = backupDir;
    }

    public SubscriptionRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(SubscriptionRegistry registry) {
        this.registry = registry;
    }
}

