/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn.resourcestate;

import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MemoryResourceStateSubscriptionDAOImpl
implements ResourceStateSubscriptionDAO {
    private Map<String, ResourceStateSubscription> byId = new HashMap<String, ResourceStateSubscription>();
    private Map<String, Collection<ResourceStateSubscription>> byPrefixAndType = new HashMap<String, Collection<ResourceStateSubscription>>();

    @Override
    public Collection<ResourceStateSubscription> listSubscriptions(String prefix, String resourceType, String resourceId) {
        return this.orDefault(this.getByPrefixAndType().get(prefix + "/" + resourceType + "/" + resourceId));
    }

    @Override
    public void addSubscription(ResourceStateSubscription subscription) {
        this.getById().put(subscription.getSubscriptionId(), subscription);
        String key = subscription.getPrefix() + "/" + subscription.getType() + "/" + subscription.getResourceId();
        Collection<ResourceStateSubscription> prefTypeList = this.getByPrefixAndType().get(key);
        if (prefTypeList == null) {
            this.getByPrefixAndType().put(key, new ArrayList());
        }
        this.getByPrefixAndType().get(key).add(subscription);
    }

    @Override
    public ResourceStateSubscription getSubscription(String subscriptionId) {
        return this.getById().get(subscriptionId);
    }

    @Override
    public Collection<ResourceStateSubscription> listSubscriptions() {
        return this.orDefault(this.getById().values());
    }

    @Override
    public Collection<ResourceStateSubscription> listSubscriptions(String prefix) {
        return this.listSubscriptions(prefix, "*", "*");
    }

    @Override
    public boolean removeSubscription(String subscriptionId) {
        ResourceStateSubscription subscription = this.getSubscription(subscriptionId);
        if (subscription == null) {
            return false;
        }
        String key = subscription.getPrefix() + "/" + subscription.getType() + "/" + subscription.getResourceId();
        Collection<ResourceStateSubscription> prefTypeList = this.getByPrefixAndType().get(key);
        prefTypeList.remove(subscription);
        this.getById().remove(subscriptionId);
        return true;
    }

    private Collection<ResourceStateSubscription> orDefault(Collection<ResourceStateSubscription> collection) {
        if (collection == null) {
            return new ArrayList<ResourceStateSubscription>();
        }
        return collection;
    }

    public Map<String, ResourceStateSubscription> getById() {
        return this.byId;
    }

    public void setById(Map<String, ResourceStateSubscription> byId) {
        this.byId = byId;
    }

    public Map<String, Collection<ResourceStateSubscription>> getByPrefixAndType() {
        return this.byPrefixAndType;
    }

    public void setByPrefixAndType(Map<String, Collection<ResourceStateSubscription>> byPrefixAndType) {
        this.byPrefixAndType = byPrefixAndType;
    }
}

