/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry;

import com.sun.xml.messaging.saaj.util.Base64;
import eu.dnetlib.common.rmi.APIDeprecatedException;
import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.CompatPendingResourceManagerImpl;
import eu.dnetlib.enabling.is.registry.ISRegistryDocumentNotFoundException;
import eu.dnetlib.enabling.is.registry.PendingResourceManager;
import eu.dnetlib.enabling.is.registry.RegistryBlackboardManager;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.is.registry.schema.OpaqueResourceValidator;
import eu.dnetlib.enabling.is.registry.schema.ValidationException;
import eu.dnetlib.enabling.is.registry.validation.ProfileValidationStrategy;
import eu.dnetlib.enabling.is.registry.validation.RegistrationPhase;
import eu.dnetlib.enabling.is.store.rmi.ISStoreException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.CompatResourceIdentifierResolverImpl;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.ResourceIdentifierResolver;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.enabling.tools.UniqueIdentifierGenerator;
import eu.dnetlib.enabling.tools.UniqueIdentifierGeneratorImpl;
import eu.dnetlib.enabling.tools.XQueryUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@WebService(targetNamespace="http://services.dnetlib.eu/")
public class ISRegistryServiceImpl
extends AbstractBaseService
implements ISRegistryService {
    private static final Log log = LogFactory.getLog(ISRegistryServiceImpl.class);
    private static final String ERROR_SEC_PROFILE = "cannot register secure profile";
    private static final String CANT_FETCH = "cannot fetch original profile";
    private static final String CANT_CREATE = "cannot create resource";
    private ISStoreService isStore;
    private ISLookUpService isLookup;
    @Resource
    private UniqueIdentifierGenerator uuidGenerator = new UniqueIdentifierGeneratorImpl();
    private PendingResourceManager pendingManager = new CompatPendingResourceManagerImpl();
    @Resource
    private ResourceIdentifierResolver resIdResolver = new CompatResourceIdentifierResolverImpl();
    private OpaqueResourceValidator resourceValidator;
    @Resource
    private ProfileValidationStrategy profileValidationStrategy;
    private XQueryUtils xqueryUtils;
    @Resource
    private RegistryBlackboardManager blackboardManager;

    public void start() {
        super.start();
    }

    public void addBlackBoardMessage(String profId, String messageId, String message) throws ISRegistryException {
        this.blackboardManager.addMessage(profId, messageId, message);
    }

    public boolean addOrUpdateResourceType(String resourceType, String resourceSchema) throws ISRegistryException {
        return this.addResourceType(resourceType, resourceSchema);
    }

    public boolean addProfileNode(String profId, String xpath, String node) throws ISRegistryException {
        throw new UnimplementedException();
    }

    public boolean addResourceType(String resourceType, String resourceSchema) throws ISRegistryException {
        try {
            return this.isStore.insertXML(resourceType, this.xqueryUtils.getRootCollection() + "DRIVERResourceTypes", resourceSchema);
        }
        catch (ISStoreException e) {
            throw new ISRegistryException("cannot add resource type", (Throwable)e);
        }
    }

    public void deleteBlackBoardMessage(String profId, String messageId) throws ISRegistryException {
        this.blackboardManager.deleteMessage(profId, messageId);
    }

    public boolean deleteProfile(String resId) throws ISRegistryException {
        try {
            boolean res = this.isStore.deleteXML(this.resIdResolver.getFileName(resId), "/db/DRIVER/" + this.resIdResolver.getCollectionName(resId));
            if (!res) {
                throw new ISRegistryDocumentNotFoundException("document " + resId + " not found");
            }
            return true;
        }
        catch (ISStoreException e) {
            throw new ISRegistryException("cannot delete profile " + resId, (Throwable)e);
        }
    }

    public boolean deleteProfiles(List<String> arrayprofId) throws ISRegistryException {
        throw new APIDeprecatedException();
    }

    public boolean deleteResourceType(String resourceType, Boolean hierarchical) throws ISRegistryException {
        try {
            return this.isStore.deleteXML(resourceType, this.xqueryUtils.getRootCollection() + "DRIVERResourceTypes");
        }
        catch (ISStoreException e) {
            throw new ISRegistryException("error deleting resource type " + resourceType, (Throwable)e);
        }
    }

    public boolean executeXUpdate(String xquery) throws ISRegistryException {
        try {
            return this.isStore.executeXUpdate(xquery);
        }
        catch (ISStoreException e) {
            throw new ISRegistryException((Throwable)e);
        }
    }

    public String insertProfileForValidation(String resourceType, String resourceProfile) throws ISRegistryException {
        try {
            StringOpaqueResource resource = new StringOpaqueResource(resourceProfile);
            if (!resourceType.equals(resource.getResourceType())) {
                throw new ISRegistryException("expected resource type doesn't match to resource");
            }
            this.pendingManager.setPending((OpaqueResource)resource, true);
            return this.registerProfile(resource.asString());
        }
        catch (XPathExpressionException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (IOException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISRegistryException((Throwable)e);
        }
    }

    public boolean refreshProfile(String profId, String resourceType) throws ISRegistryException {
        throw new UnimplementedException();
    }

    public String registerProfile(String resourceProfile) throws ISRegistryException {
        log.debug((Object)"registering profile");
        try {
            StringOpaqueResource resource = new StringOpaqueResource(resourceProfile);
            String coll = this.xqueryUtils.getCollectionPath((OpaqueResource)resource);
            String fileName = this.uuidGenerator.generateIdentifier();
            String newId = fileName + "_" + new String(Base64.encode((byte[])coll.getBytes()));
            resource.setResourceId(newId);
            resource.setModificationDate(new Date());
            this.resourceValidator.validate((OpaqueResource)resource);
            this.profileValidationStrategy.accept((OpaqueResource)resource, RegistrationPhase.Register);
            this.isStore.insertXML(fileName, this.xqueryUtils.getRootCollection() + coll, resource.asString());
            return resource.getResourceId();
        }
        catch (XPathExpressionException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (IOException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ISStoreException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ISRegistryException("profile is not conforming to the schema: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerSecureProfile(String resourceProfId, String secureProfId) throws ISRegistryException {
        try {
            ISRegistryServiceImpl iSRegistryServiceImpl = this;
            synchronized (iSRegistryServiceImpl) {
                String secureProfSrc;
                try {
                    secureProfSrc = this.isLookup.getResourceProfile(secureProfId);
                }
                catch (ISLookUpDocumentNotFoundException e) {
                    throw new ISRegistryException("cannot register secure profile, the given secure profile doesn't exist", (Throwable)e);
                }
                StringOpaqueResource secureProf = new StringOpaqueResource(secureProfSrc);
                String profId = this.validateProfile(resourceProfId);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Element idEl = (Element)xpath.evaluate("/RESOURCE_PROFILE/BODY/CONFIGURATION/resourceId", secureProf.asDom(), XPathConstants.NODE);
                idEl.setTextContent(profId);
                if (!this.updateProfile(secureProfId, secureProf.asString(), secureProf.getResourceType())) {
                    throw new ISRegistryException("cannot update security profile (updateProfile returned false)");
                }
                return profId;
            }
        }
        catch (XPathExpressionException e) {
            throw new ISRegistryException(ERROR_SEC_PROFILE, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ISRegistryException(ERROR_SEC_PROFILE, (Throwable)e);
        }
        catch (IOException e) {
            throw new ISRegistryException(ERROR_SEC_PROFILE, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISRegistryException(ERROR_SEC_PROFILE, (Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new ISRegistryException("cannot register secure profile, problem fetching the given secure profile", (Throwable)e);
        }
    }

    public boolean removeProfileNode(String profId, String nodeId) throws ISRegistryException {
        throw new UnimplementedException();
    }

    public void replyBlackBoardMessage(String profId, String message) throws ISRegistryException {
        this.blackboardManager.replyMessage(profId, message);
    }

    public boolean updateProfile(String resId, String resourceProfile, String resourceType) throws ISRegistryException {
        try {
            String fileName = this.resIdResolver.getFileName(resId);
            String fileColl = "/db/DRIVER/" + this.resIdResolver.getCollectionName(resId);
            String oldProfileSrc = this.isStore.getXML(fileName, fileColl);
            if (oldProfileSrc == null) {
                throw new ISRegistryException("cannot update a non existing profile " + resId);
            }
            StringOpaqueResource oldResource = new StringOpaqueResource(oldProfileSrc);
            StringOpaqueResource newResource = new StringOpaqueResource(resourceProfile);
            newResource.setResourceId(oldResource.getResourceId());
            newResource.setResourceKind(oldResource.getResourceKind());
            newResource.setResourceType(oldResource.getResourceType());
            newResource.setModificationDate(new Date());
            this.getResourceValidator().validate((OpaqueResource)newResource);
            return this.isStore.updateXML(fileName, fileColl, newResource.asString());
        }
        catch (ISStoreException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ISRegistryException("profile not conforming to xml schema", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (IOException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISRegistryException((Throwable)e);
        }
    }

    public String updateProfileDHN(String resourceProfile) throws ISRegistryException {
        throw new UnimplementedException();
    }

    public boolean updateProfileNode(String profId, String xpath, String node) throws ISRegistryException {
        return this.executeXUpdate("for $x in collection('/db/DRIVER')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value eq '" + profId + "']" + xpath + " return update replace $x with " + node);
    }

    public boolean updateRegionDescription(String profId, String resourceProfile) throws ISRegistryException {
        throw new UnimplementedException();
    }

    public String validateProfile(String profId) throws ISRegistryException {
        try {
            String resourceProfile = this.isLookup.getResourceProfile(profId);
            StringOpaqueResource resource = new StringOpaqueResource(resourceProfile);
            this.pendingManager.setValid((OpaqueResource)resource);
            return resource.getResourceId();
        }
        catch (ISLookUpException e) {
            throw new ISRegistryException(CANT_FETCH, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
        catch (IOException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
    }

    public String invalidateProfile(String profId) throws ISRegistryException {
        try {
            String resourceProfile = this.isLookup.getResourceProfile(profId);
            StringOpaqueResource resource = new StringOpaqueResource(resourceProfile);
            this.pendingManager.setPending((OpaqueResource)resource);
            return resource.getResourceId();
        }
        catch (ISLookUpException e) {
            throw new ISRegistryException(CANT_FETCH, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
        catch (IOException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISRegistryException(CANT_CREATE, (Throwable)e);
        }
    }

    public List<String> validateProfiles(List<String> profIds) throws ISRegistryException {
        throw new APIDeprecatedException();
    }

    public UniqueIdentifierGenerator getUuidGenerator() {
        return this.uuidGenerator;
    }

    public void setUuidGenerator(UniqueIdentifierGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    public PendingResourceManager getPendingManager() {
        return this.pendingManager;
    }

    public void setPendingManager(PendingResourceManager pendingManager) {
        this.pendingManager = pendingManager;
    }

    public ResourceIdentifierResolver getResIdResolver() {
        return this.resIdResolver;
    }

    public void setResIdResolver(ResourceIdentifierResolver resIdResolver) {
        this.resIdResolver = resIdResolver;
    }

    public OpaqueResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    @Required
    public void setResourceValidator(OpaqueResourceValidator resourceValidator) {
        this.resourceValidator = resourceValidator;
    }

    @Required
    public void setXqueryUtils(XQueryUtils xqueryUtils) {
        this.xqueryUtils = xqueryUtils;
    }

    public XQueryUtils getXqueryUtils() {
        return this.xqueryUtils;
    }

    public RegistryBlackboardManager getBlackboardManager() {
        return this.blackboardManager;
    }

    public void setBlackboardManager(RegistryBlackboardManager blackboardManager) {
        this.blackboardManager = blackboardManager;
    }

    public ProfileValidationStrategy getProfileValidationStrategy() {
        return this.profileValidationStrategy;
    }

    public void setProfileValidationStrategy(ProfileValidationStrategy profileValidationStrategy) {
        this.profileValidationStrategy = profileValidationStrategy;
    }

    public ISStoreService getIsStore() {
        return this.isStore;
    }

    @Required
    public void setIsStore(ISStoreService isStore) {
        this.isStore = isStore;
    }

    public ISLookUpService getIsLookup() {
        return this.isLookup;
    }

    @Required
    public void setIsLookup(ISLookUpService isLookup) {
        this.isLookup = isLookup;
    }
}

