/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.lookup;

import com.sun.xml.messaging.saaj.util.Base64;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.store.rmi.ISStoreException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.CompatResourceIdentifierResolverImpl;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.ResourceIdentifierResolver;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.enabling.tools.XQueryUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

@WebService(targetNamespace="http://services.dnetlib.eu/")
public class ISLookUpServiceImpl
extends AbstractBaseService
implements ISLookUpService {
    private static final String COLLECTION_ERROR = "cannot get collection";
    private static final String DB_BASE_DIR = "/db/DRIVER";
    private static final String PROFILE_NOT_FOUND = "Profile not found";
    private ISStoreService isStore;
    public static final Log log = LogFactory.getLog(ISLookUpServiceImpl.class);
    private ResourceIdentifierResolver resIdManager = new CompatResourceIdentifierResolverImpl();
    private XQueryUtils xqueryUtils;

    public Boolean flushCachedResultSets() {
        return false;
    }

    public String retrieveCollection(String profId) throws ISLookUpException {
        try {
            String profile = this.getResourceProfile(profId);
            List<String> list = this.quickSearchProfile("for $x in collection('/db/DRIVER/CollectionDSResources') where $x//FATHER/@id = '" + profId + "' return $x//RESOURCE_IDENTIFIER/@value/string()");
            if (!list.isEmpty()) {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(profile));
                Element childrenNode = (Element)doc.selectSingleNode("//CHILDREN");
                for (String idC : list) {
                    childrenNode.addElement("CHILD").addAttribute("id", idC);
                }
                profile = doc.asXML();
            }
            return profile;
        }
        catch (Exception e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public String getCollection(String profId, String format) throws ISLookUpException {
        try {
            StringOpaqueResource prof = new StringOpaqueResource(profId);
            StringBuilder query = new StringBuilder();
            if (format != null && format.equals("ui")) {
                query.append("doc('");
                query.append(this.xqueryUtils.getCollectionAbsPath((OpaqueResource)prof));
                query.append('/');
                query.append(prof.getResourceId().split("_")[0]);
                query.append("')");
            } else {
                query.append("let $x := doc('");
                query.append(this.xqueryUtils.getCollectionAbsPath((OpaqueResource)prof));
                query.append('/');
                query.append(prof.getResourceId().split("_")[0]);
                query.append("') return <COLLECTION name='{$x//NAME}' id='{$x//RESOURCE_IDENTIFIER/@value/string()}'>");
                query.append("<STATUS private='{$x//PRIVATE}' visible='{$x//VISIBLE}' container='{$x//CONTAINER}'");
                query.append("count_docs='{$x//COUNT_DOCS/@number/string()}' last_update='{$x//COUNT_DOCS/@last_update/string()}' />");
                query.append("{$x//IMAGE_URL}{$x//DESCRIPTION}{$x//OWNER}{$x//FATHER}{$x//SUBJECT}{$x//CHILDREN}{$x//MEMBERSHIP_CONDITION}{$x//RETRIEVAL_CONDITION}</COLLECTION>");
            }
            return this.isStore.getXMLbyQuery(query.toString());
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new ISLookUpException(COLLECTION_ERROR, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ISLookUpException(COLLECTION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new ISLookUpException(COLLECTION_ERROR, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ISLookUpException(COLLECTION_ERROR, (Throwable)e);
        }
    }

    public String getResourceProfile(String profId) throws ISLookUpException {
        if (profId == null || profId.isEmpty()) {
            throw new ISLookUpException("Invalid null profile ID: " + profId);
        }
        try {
            String res = this.isStore.getXML(this.getFileNameForId(profId), this.xqueryUtils.getRootCollection() + this.getFileCollForId(profId));
            if (res == null) {
                throw new ISLookUpDocumentNotFoundException("document " + profId + " not found");
            }
            return res;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    String getFileNameForId(String profId) {
        return this.resIdManager.getFileName(profId);
    }

    String getFileCollForId(String profId) {
        return this.resIdManager.getCollectionName(profId);
    }

    public String getResourceProfileByQuery(String xquery) throws ISLookUpException {
        try {
            String resource = this.isStore.getXMLbyQuery(xquery);
            if (resource == null || resource.isEmpty()) {
                throw new ISLookUpDocumentNotFoundException(PROFILE_NOT_FOUND);
            }
            return resource;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public String getResourceQoSParams(String profId) throws ISLookUpException {
        String query = "for $x in collection('/db/DRIVER/ServiceResources') where $x//RESOURCE_IDENTIFIER/@value = '" + profId + "' return $x//QOS";
        return this.getResourceProfileByQuery(query);
    }

    public String getResourceTypeSchema(String resourceType) throws ISLookUpException, ISLookUpDocumentNotFoundException {
        if (resourceType == null || resourceType.isEmpty()) {
            throw new ISLookUpException("Invalid resourceType");
        }
        try {
            String resource = this.isStore.getXML(resourceType, this.xqueryUtils.getRootCollection() + "DRIVERResourceTypes");
            if (resource == null || resource.isEmpty()) {
                throw new ISLookUpDocumentNotFoundException(PROFILE_NOT_FOUND);
            }
            return resource;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public List<String> listCollections(String format, String idfatherParam, String owner) throws ISLookUpException {
        String idfather = idfatherParam;
        if (idfather == null || idfather.length() == 0) {
            idfather = "InfoSpace";
        }
        String fileColl = this.xqueryUtils.getRootCollection() + "CollectionDSResources/CollectionDSResourceType";
        StringBuilder query = new StringBuilder();
        query.append("for $x in collection('" + fileColl + "') where $x//FATHER[@id='" + idfather + "'] ");
        if (owner != null && owner.length() > 0) {
            query.append("and $x//OWNER[@id='" + owner + "'] ");
        }
        if (format != null && format.equals("short")) {
            query.append("return $x//RESOURCE_IDENTIFIER/@value/string()");
        } else {
            query.append("return $x");
        }
        return this.quickSearchProfile(query.toString());
    }

    public List<String> listDHNIDs() throws ISLookUpException {
        String fileColl = "/db/DRIVER/InfrastructureResources/DRIVERHostingNodeDSResourceType";
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (String i : this.isStore.getFileNames("/db/DRIVER/InfrastructureResources/DRIVERHostingNodeDSResourceType")) {
                ret.add(i + ":" + "/db/DRIVER/InfrastructureResources/DRIVERHostingNodeDSResourceType");
            }
            return ret;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public List<String> listResourceTypes() throws ISLookUpException {
        try {
            return this.isStore.getFileNames("/db/DRIVER/DRIVERResourceTypes");
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public List<String> listServiceIDs(String serviceType) throws ISLookUpException {
        String fileColl = "ServiceResources/" + serviceType;
        String encodedColl = "_" + new String(Base64.encode((byte[])fileColl.getBytes()));
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (String i : this.isStore.getFileNames("/db/DRIVER/" + fileColl)) {
                ret.add(i + encodedColl);
            }
            return ret;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public List<String> listServiceTypes() throws ISLookUpException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (String i : this.isStore.getFileColls()) {
                if (!i.startsWith("ServiceResources/")) continue;
                ret.add(i.substring("ServiceResources/".length()));
            }
            return ret;
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public List<String> quickSearchProfile(String xquery) throws ISLookUpException {
        try {
            return this.isStore.quickSearchXML(xquery);
        }
        catch (ISStoreException e) {
            throw new ISLookUpException((Throwable)e);
        }
    }

    public ResourceIdentifierResolver getResIdManager() {
        return this.resIdManager;
    }

    public void setResIdManager(ResourceIdentifierResolver resIdManager) {
        this.resIdManager = resIdManager;
    }

    @Required
    public void setXqueryUtils(XQueryUtils xqueryUtils) {
        this.xqueryUtils = xqueryUtils;
    }

    public XQueryUtils getXqueryUtils() {
        return this.xqueryUtils;
    }

    public ISStoreService getIsStore() {
        return this.isStore;
    }

    @Required
    public void setIsStore(ISStoreService isStore) {
        this.isStore = isStore;
    }
}

