/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.AbstractNotificationDetector;
import eu.dnetlib.enabling.is.sn.NotificationMessage;
import eu.dnetlib.enabling.is.sn.SubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateNotificationDetector;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.tools.OpaqueResource;
import java.io.StringWriter;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class NotificationDetectorImpl
extends AbstractNotificationDetector
implements ResourceStateNotificationDetector<OpaqueResource> {
    private static final Log log = LogFactory.getLog(NotificationDetectorImpl.class);
    private SubscriptionRegistry registry;

    @Override
    public void resourceCreated(OpaqueResource newResource) {
        log.debug((Object)("resource created: " + this.getRegistry()));
        Collection<ResourceStateSubscription> subs = this.getRegistry().listMatchingSubscriptions("CREATE", newResource.getResourceType(), newResource.getResourceId());
        for (ResourceStateSubscription sub : subs) {
            if (!this.matchPath(newResource, sub.getXpath())) continue;
            this.send(sub, newResource, "CREATE");
        }
    }

    private void send(ResourceStateSubscription sub, OpaqueResource resource, String prefix) {
        log.debug((Object)("RESOURCE " + resource));
        log.debug((Object)("id: " + resource.getResourceId()));
        log.debug((Object)("dom: " + resource.asDom()));
        StringBuffer topicBuffer = new StringBuffer();
        if (sub.getPrefix() == null && "*".equals(sub.getPrefix())) {
            topicBuffer.append(prefix);
        } else {
            topicBuffer.append(sub.getPrefix());
        }
        topicBuffer.append('.');
        topicBuffer.append(sub.getType());
        topicBuffer.append('.');
        topicBuffer.append(sub.getResourceId());
        if (sub.getXpath() != null && !sub.getXpath().isEmpty()) {
            topicBuffer.append(sub.getXpath().replace('/', '.'));
        }
        this.getSender().send(sub.getSubscriberAsEpr(), new NotificationMessage(sub.getSubscriptionId(), topicBuffer.toString(), resource.getResourceId(), resource.asString()));
    }

    @Override
    public void resourceDeleted(OpaqueResource oldResource) {
        log.debug((Object)("resource deleted: " + this.getRegistry()));
        Collection<ResourceStateSubscription> subs = this.registry.listMatchingSubscriptions("DELETE", oldResource.getResourceType(), oldResource.getResourceId());
        for (ResourceStateSubscription sub : subs) {
            if (!this.matchPath(oldResource, sub.getXpath())) continue;
            this.send(sub, oldResource, "DELETE");
        }
    }

    @Override
    public void resourceUpdated(OpaqueResource oldResource, OpaqueResource newResource) {
        log.debug((Object)("resource updated: " + this.getRegistry()));
        Collection<ResourceStateSubscription> subs = this.registry.listMatchingSubscriptions("UPDATE", oldResource.getResourceType(), oldResource.getResourceId());
        for (ResourceStateSubscription sub : subs) {
            if (!this.comparePath(oldResource, newResource, sub.getXpath())) continue;
            log.debug((Object)("updated, sending: " + newResource.asString()));
            this.send(sub, newResource, "UPDATE");
        }
    }

    private boolean matchPath(OpaqueResource resource, String xpath) {
        if (xpath == null || xpath.isEmpty()) {
            return true;
        }
        XPath xpa = XPathFactory.newInstance().newXPath();
        try {
            return !xpa.evaluate(xpath, resource.asDom()).isEmpty();
        }
        catch (XPathExpressionException e) {
            log.warn((Object)"wrong xpath expression, notification possibly missed", (Throwable)e);
            return false;
        }
    }

    private boolean comparePath(OpaqueResource oldResource, OpaqueResource newResource, String xpath) {
        if (oldResource == null || newResource == null || xpath == null || xpath.isEmpty()) {
            return true;
        }
        XPath xpa = XPathFactory.newInstance().newXPath();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            Node left = (Node)xpa.evaluate(xpath, oldResource.asDom(), XPathConstants.NODE);
            Node right = (Node)xpa.evaluate(xpath, newResource.asDom(), XPathConstants.NODE);
            if (left == null || right == null) {
                if (left != null) {
                    return true;
                }
                return right != null;
            }
            StringWriter leftWriter = new StringWriter();
            StringWriter rightWriter = new StringWriter();
            transformer.transform(new DOMSource(left), new StreamResult(leftWriter));
            transformer.transform(new DOMSource(right), new StreamResult(rightWriter));
            return !leftWriter.toString().equals(rightWriter.toString());
        }
        catch (XPathExpressionException e) {
            log.warn((Object)"wrong xpath expression, notification possibly missed", (Throwable)e);
        }
        catch (TransformerException e) {
            log.warn((Object)"serialization problem", (Throwable)e);
        }
        return false;
    }

    public SubscriptionRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(SubscriptionRegistry registry) {
        this.registry = registry;
    }
}

