/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateNotificationDetector;
import eu.dnetlib.enabling.tools.DOMOpaqueResource;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.xml.database.LoggingTrigger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class NotificationTriggerImpl
extends LoggingTrigger {
    private static final Log log = LogFactory.getLog(NotificationTriggerImpl.class);
    private ResourceStateNotificationDetector<OpaqueResource> detector;

    public void created(String file, String collection, Document newDoc) {
        super.created(file, collection, newDoc);
        try {
            this.getDetector().resourceCreated((OpaqueResource)new DOMOpaqueResource(newDoc));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot detect notification because of xpath error; notification possibly missed", (Throwable)e);
        }
    }

    public void deleted(String file, String collection, Document oldDoc) {
        super.deleted(file, collection, oldDoc);
        try {
            this.getDetector().resourceDeleted((OpaqueResource)new DOMOpaqueResource(oldDoc));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot detect notification because of xpath error; notification possibly missed", (Throwable)e);
        }
    }

    public void updated(String file, String collection, Document oldDoc, Document newDoc) {
        super.updated(file, collection, oldDoc, newDoc);
        try {
            this.getDetector().resourceUpdated((OpaqueResource)new DOMOpaqueResource(oldDoc), (OpaqueResource)new DOMOpaqueResource(newDoc));
        }
        catch (XPathExpressionException e) {
            log.fatal((Object)"cannot detect notification because of xpath error; notification possibly missed", (Throwable)e);
        }
    }

    public ResourceStateNotificationDetector<OpaqueResource> getDetector() {
        return this.detector;
    }

    public void setDetector(ResourceStateNotificationDetector<OpaqueResource> detector) {
        this.detector = detector;
    }
}

